/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamworkshop.callback;

import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverUcm;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.JobID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class UserActionPublishedFilesCallback
extends CallbackMsg {
    private final EResult result;
    private final List<File> files;
    private final int totalResults;

    public UserActionPublishedFilesCallback(JobID jobID, SteammessagesClientserverUcm.CMsgClientUCMEnumeratePublishedFilesByUserActionResponse.Builder msg) {
        this.setJobID(jobID);
        this.result = EResult.from(msg.getEresult());
        ArrayList<File> fileList = new ArrayList<File>();
        for (SteammessagesClientserverUcm.CMsgClientUCMEnumeratePublishedFilesByUserActionResponse.PublishedFileId f : msg.getPublishedFilesList()) {
            fileList.add(new File(f));
        }
        this.files = Collections.unmodifiableList(fileList);
        this.totalResults = msg.getTotalResults();
    }

    public EResult getResult() {
        return this.result;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public static class File {
        private final long fileID;
        private final Date timestamp;

        public File(SteammessagesClientserverUcm.CMsgClientUCMEnumeratePublishedFilesByUserActionResponse.PublishedFileId file) {
            this.fileID = file.getPublishedFileId();
            this.timestamp = new Date((long)file.getRtimeTimeStamp() * 1000L);
        }

        public long getFileID() {
            return this.fileID;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }
    }
}

