/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.steamclient.callbackmgr;

import in.dragonbra.javasteam.steam.steamclient.SteamClient;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.Callback;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackBase;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.ICallbackMgrInternals;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.ICallbackMsg;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.Subscription;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CallbackManager
implements ICallbackMgrInternals {
    private final SteamClient steamClient;
    private final Set<CallbackBase> registeredCallbacks = Collections.newSetFromMap(new ConcurrentHashMap());

    public CallbackManager(SteamClient steamClient) {
        if (steamClient == null) {
            throw new IllegalArgumentException("steamclient is null");
        }
        this.steamClient = steamClient;
    }

    public void runCallbacks() {
        ICallbackMsg call = this.steamClient.getCallback(true);
        if (call != null) {
            this.handle(call);
        }
    }

    public void runWaitCallbacks(long timeout) {
        ICallbackMsg call = this.steamClient.waitForCallback(true, timeout);
        if (call != null) {
            this.handle(call);
        }
    }

    public void runWaitCallbacks() {
        ICallbackMsg call = this.steamClient.waitForCallback(true);
        if (call != null) {
            this.handle(call);
        }
    }

    public void runWaitAllCallbacks(int timeout) {
        List<ICallbackMsg> calls = this.steamClient.getAllCallbacks(true, timeout);
        for (ICallbackMsg call : calls) {
            this.handle(call);
        }
    }

    public <TCallback extends ICallbackMsg> Closeable subscribe(Class<? extends TCallback> callbackType, JobID jobID, Consumer<TCallback> callbackFunc) {
        if (jobID == null) {
            throw new IllegalArgumentException("jobID is null");
        }
        if (callbackFunc == null) {
            throw new IllegalArgumentException("callbackFunc is null");
        }
        Callback<? extends TCallback> callback = new Callback<TCallback>(callbackType, callbackFunc, this, jobID);
        return new Subscription(this, callback);
    }

    public <TCallback extends ICallbackMsg> Closeable subscribe(Class<? extends TCallback> callbackType, Consumer<TCallback> callbackFunc) {
        return this.subscribe(callbackType, JobID.INVALID, callbackFunc);
    }

    @Override
    public void register(CallbackBase callback) {
        this.registeredCallbacks.add(callback);
    }

    @Override
    public void unregister(CallbackBase callback) {
        this.registeredCallbacks.remove(callback);
    }

    private void handle(ICallbackMsg call) {
        for (CallbackBase callback : this.registeredCallbacks) {
            if (!callback.getCallbackType().isAssignableFrom(call.getClass())) continue;
            callback.run(call);
        }
    }
}

