/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.types;

import in.dragonbra.javasteam.enums.EAccountType;
import in.dragonbra.javasteam.enums.EUniverse;
import in.dragonbra.javasteam.types.BitVector64;
import in.dragonbra.javasteam.util.CollectionUtils;
import in.dragonbra.javasteam.util.Strings;
import in.dragonbra.javasteam.util.compat.ObjectsCompat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SteamID {
    private final BitVector64 steamID;
    private static final Pattern STEAM2_REGEX = Pattern.compile("STEAM_([0-4]):([0-1]):(\\d+)", 2);
    private static final Pattern STEAM3_REGEX = Pattern.compile("\\[([AGMPCgcLTIUai]):([0-4]):(\\d+)(:(\\d+))?]");
    private static final Pattern STEAM3_FALLBACK_REGEX = Pattern.compile("\\[([AGMPCgcLTIUai]):([0-4]):(\\d+)(\\((\\d+)\\))?]");
    private static final Map<EAccountType, Character> ACCOUNT_TYPE_CHARS;
    public static final char UNKNOWN_ACCOUNT_TYPE_CHAR = 'i';
    public static final long ALL_INSTANCES = 0L;
    public static final long DESKTOP_INSTANCE = 1L;
    public static final long CONSOLE_INSTANCE = 2L;
    public static final long WEB_INSTANCE = 4L;
    public static final long ACCOUNT_ID_MASK = 0xFFFFFFFFL;
    public static final long ACCOUNT_INSTANCE_MASK = 1048575L;

    public SteamID() {
        this(0L);
    }

    public SteamID(long unAccountID, EUniverse eUniverse, EAccountType eAccountType) {
        this();
        this.set(unAccountID, eUniverse, eAccountType);
    }

    public SteamID(long unAccountID, long unInstance, EUniverse eUniverse, EAccountType eAccountType) {
        this();
        this.instancedSet(unAccountID, unInstance, eUniverse, eAccountType);
    }

    public SteamID(long id) {
        this.steamID = new BitVector64(id);
    }

    public SteamID(String steamId) {
        this(steamId, EUniverse.Public);
    }

    public SteamID(String steamId, EUniverse eUniverse) {
        this();
        this.setFromString(steamId, eUniverse);
    }

    public void set(long unAccountID, EUniverse eUniverse, EAccountType eAccountType) {
        this.setAccountID(unAccountID);
        this.setAccountUniverse(eUniverse);
        this.setAccountType(eAccountType);
        if (eAccountType == EAccountType.Clan || eAccountType == EAccountType.GameServer) {
            this.setAccountInstance(0L);
        } else {
            this.setAccountInstance(1L);
        }
    }

    public void instancedSet(long unAccountID, long unInstance, EUniverse eUniverse, EAccountType eAccountType) {
        this.setAccountID(unAccountID);
        this.setAccountUniverse(eUniverse);
        this.setAccountType(eAccountType);
        this.setAccountInstance(unInstance);
    }

    public boolean setFromString(String steamId, EUniverse eUniverse) {
        long authServer;
        long accountId;
        if (Strings.isNullOrEmpty(steamId)) {
            return false;
        }
        Matcher matcher = STEAM2_REGEX.matcher(steamId);
        if (!matcher.matches()) {
            return false;
        }
        try {
            accountId = Long.parseLong(matcher.group(3));
            authServer = Long.parseLong(matcher.group(2));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        this.setAccountUniverse(eUniverse);
        this.setAccountInstance(1L);
        this.setAccountType(EAccountType.Individual);
        this.setAccountID(accountId << 1 | authServer);
        return true;
    }

    public boolean setFromSteam3String(String steamId) {
        long instance;
        long universe;
        long accId;
        if (Strings.isNullOrEmpty(steamId)) {
            return false;
        }
        Matcher matcher = STEAM3_REGEX.matcher(steamId);
        if (!matcher.matches() && !(matcher = STEAM3_FALLBACK_REGEX.matcher(steamId)).matches()) {
            return false;
        }
        try {
            accId = Long.parseLong(matcher.group(3));
            universe = Long.parseLong(matcher.group(2));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        String typeString = matcher.group(1);
        if (typeString.length() != 1) {
            return false;
        }
        char type = typeString.charAt(0);
        String instanceGroup = matcher.group(5);
        if (!Strings.isNullOrEmpty(instanceGroup)) {
            instance = Long.parseLong(instanceGroup);
        } else {
            switch (type) {
                case 'L': 
                case 'T': 
                case 'c': 
                case 'g': {
                    instance = 0L;
                    break;
                }
                default: {
                    instance = 1L;
                }
            }
        }
        if (type == 'c') {
            instance |= ChatInstanceFlags.CLAN.code();
            this.setAccountType(EAccountType.Chat);
        } else if (type == 'L') {
            instance |= ChatInstanceFlags.LOBBY.code();
            this.setAccountType(EAccountType.Chat);
        } else if (type == 'i') {
            this.setAccountType(EAccountType.Invalid);
        } else {
            this.setAccountType(CollectionUtils.getKeyByValue(ACCOUNT_TYPE_CHARS, Character.valueOf(type)));
        }
        this.setAccountUniverse(EUniverse.from((int)universe));
        this.setAccountInstance(instance);
        this.setAccountID(accId);
        return true;
    }

    public void setFromUInt64(long longSteamId) {
        this.steamID.setData(longSteamId);
    }

    public long convertToUInt64() {
        return this.steamID.getData();
    }

    public long getStaticAccountKey() {
        return ((long)this.getAccountUniverse().code() << 56) + ((long)this.getAccountType().code() << 52) + this.getAccountID();
    }

    public boolean isBlankAnonAccount() {
        return this.getAccountID() == 0L && this.isAnonAccount() && this.getAccountInstance() == 0L;
    }

    public boolean isGameServerAccount() {
        return this.getAccountType() == EAccountType.GameServer || this.getAccountType() == EAccountType.AnonGameServer;
    }

    public boolean isPersistentGameServerAccount() {
        return this.getAccountType() == EAccountType.GameServer;
    }

    public boolean isAnonGameServerAccount() {
        return this.getAccountType() == EAccountType.AnonGameServer;
    }

    public boolean isContentServerAccount() {
        return this.getAccountType() == EAccountType.ContentServer;
    }

    public boolean isClanAccount() {
        return this.getAccountType() == EAccountType.Clan;
    }

    public boolean isChatAccount() {
        return this.getAccountType() == EAccountType.Chat;
    }

    public boolean isLobby() {
        return this.getAccountType() == EAccountType.Chat && (this.getAccountInstance() & ChatInstanceFlags.LOBBY.code()) > 0L;
    }

    public boolean isIndividualAccount() {
        return this.getAccountType() == EAccountType.Individual || this.getAccountType() == EAccountType.ConsoleUser;
    }

    public boolean isAnonAccount() {
        return this.getAccountType() == EAccountType.AnonUser || this.getAccountType() == EAccountType.AnonGameServer;
    }

    public boolean isAnonUserAccount() {
        return this.getAccountType() == EAccountType.AnonUser;
    }

    public boolean isConsoleUserAccount() {
        return this.getAccountType() == EAccountType.ConsoleUser;
    }

    public boolean isValid() {
        if (this.getAccountType().code() <= EAccountType.Invalid.code() || this.getAccountType().code() > EAccountType.AnonUser.code()) {
            return false;
        }
        if (this.getAccountUniverse().code() <= EUniverse.Invalid.code() || this.getAccountUniverse().code() > EUniverse.Dev.code()) {
            return false;
        }
        if (this.getAccountType() == EAccountType.Individual && (this.getAccountID() == 0L || this.getAccountInstance() > 4L)) {
            return false;
        }
        if (this.getAccountType() == EAccountType.Clan && (this.getAccountID() == 0L || this.getAccountInstance() != 0L)) {
            return false;
        }
        return this.getAccountType() != EAccountType.GameServer || this.getAccountID() != 0L;
    }

    public long getAccountID() {
        return this.steamID.getMask((short)0, 0xFFFFFFFFL);
    }

    public void setAccountID(long accountID) {
        this.steamID.setMask((short)0, 0xFFFFFFFFL, accountID);
    }

    public long getAccountInstance() {
        return this.steamID.getMask((short)32, 1048575L);
    }

    public void setAccountInstance(long accountInstance) {
        this.steamID.setMask((short)32, 1048575L, accountInstance);
    }

    public EAccountType getAccountType() {
        return EAccountType.from((int)this.steamID.getMask((short)52, 15L));
    }

    public void setAccountType(EAccountType accountType) {
        this.steamID.setMask((short)52, 15L, accountType == null ? 105L : (long)accountType.code());
    }

    public EUniverse getAccountUniverse() {
        return EUniverse.from((int)this.steamID.getMask((short)56, 255L));
    }

    public void setAccountUniverse(EUniverse accountUniverse) {
        this.steamID.setMask((short)56, 255L, accountUniverse.code());
    }

    public SteamID toChatID() {
        if (!this.isClanAccount()) {
            throw new IllegalStateException("Only Clan IDs can be converted to Chat IDs.");
        }
        SteamID chatID = new SteamID(this.convertToUInt64());
        chatID.setAccountInstance(ChatInstanceFlags.CLAN.code());
        chatID.setAccountType(EAccountType.Chat);
        return chatID;
    }

    public SteamID tryGetClanID() {
        if (this.isChatAccount() && this.getAccountInstance() == ChatInstanceFlags.CLAN.code()) {
            SteamID groupID = new SteamID(this.convertToUInt64());
            groupID.setAccountType(EAccountType.Clan);
            groupID.setAccountInstance(0L);
            return groupID;
        }
        return null;
    }

    public String render() {
        return this.render(true);
    }

    public String render(boolean steam3) {
        return steam3 ? this.renderSteam3() : this.renderSteam2();
    }

    private String renderSteam2() {
        switch (this.getAccountType()) {
            case Invalid: 
            case Individual: {
                String universeDigit = this.getAccountUniverse().code() <= EUniverse.Public.code() ? "0" : String.valueOf(this.getAccountUniverse().code());
                return String.format("STEAM_%s:%d:%d", universeDigit, this.getAccountID() & 1L, this.getAccountID() >> 1);
            }
        }
        return String.valueOf(this.steamID.getData());
    }

    private String renderSteam3() {
        Character accountTypeChar = ACCOUNT_TYPE_CHARS.get((Object)this.getAccountType());
        if (accountTypeChar == null) {
            accountTypeChar = Character.valueOf('i');
        }
        if (this.getAccountType() == EAccountType.Chat) {
            if ((this.getAccountInstance() & ChatInstanceFlags.CLAN.code()) > 0L) {
                accountTypeChar = Character.valueOf('c');
            } else if ((this.getAccountInstance() & ChatInstanceFlags.LOBBY.code()) > 0L) {
                accountTypeChar = Character.valueOf('L');
            }
        }
        boolean renderInstance = false;
        switch (this.getAccountType()) {
            case AnonGameServer: 
            case Multiseat: {
                renderInstance = true;
                break;
            }
            case Individual: {
                boolean bl = renderInstance = this.getAccountInstance() != 1L;
            }
        }
        if (renderInstance) {
            return String.format("[%s:%d:%d:%d]", accountTypeChar, this.getAccountUniverse().code(), this.getAccountID(), this.getAccountInstance());
        }
        return String.format("[%s:%d:%d]", accountTypeChar, this.getAccountUniverse().code(), this.getAccountID());
    }

    public String toString() {
        return this.render();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SteamID)) {
            return false;
        }
        SteamID sid = (SteamID)obj;
        return ObjectsCompat.equals(this.steamID.getData(), sid.steamID.getData());
    }

    public int hashCode() {
        return this.steamID.getData().hashCode();
    }

    static {
        HashMap<EAccountType, Character> accountTypeChars = new HashMap<EAccountType, Character>();
        accountTypeChars.put(EAccountType.AnonGameServer, Character.valueOf('A'));
        accountTypeChars.put(EAccountType.GameServer, Character.valueOf('G'));
        accountTypeChars.put(EAccountType.Multiseat, Character.valueOf('M'));
        accountTypeChars.put(EAccountType.Pending, Character.valueOf('P'));
        accountTypeChars.put(EAccountType.ContentServer, Character.valueOf('C'));
        accountTypeChars.put(EAccountType.Clan, Character.valueOf('g'));
        accountTypeChars.put(EAccountType.Chat, Character.valueOf('T'));
        accountTypeChars.put(EAccountType.Invalid, Character.valueOf('I'));
        accountTypeChars.put(EAccountType.Individual, Character.valueOf('U'));
        accountTypeChars.put(EAccountType.AnonUser, Character.valueOf('a'));
        ACCOUNT_TYPE_CHARS = Collections.unmodifiableMap(accountTypeChars);
    }

    public static enum ChatInstanceFlags {
        CLAN(524288L),
        LOBBY(262144L),
        MMS_LOBBY(131072L);

        private final long code;

        private ChatInstanceFlags(long code) {
            this.code = code;
        }

        public long code() {
            return this.code;
        }

        public static ChatInstanceFlags from(long code) {
            for (ChatInstanceFlags e : ChatInstanceFlags.values()) {
                if (e.code != code) continue;
                return e;
            }
            return null;
        }
    }
}

