/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util.event;

import java.util.Timer;
import java.util.TimerTask;

public class ScheduledFunction {
    private long delay;
    private final Runnable func;
    private Timer timer;
    private boolean bStarted = false;

    public ScheduledFunction(Runnable func, long delay) {
        this.delay = delay;
        this.func = func;
    }

    public void start() {
        if (!this.bStarted) {
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (ScheduledFunction.this.func != null) {
                        ScheduledFunction.this.func.run();
                    }
                }
            }, 0L, this.delay);
            this.bStarted = true;
        }
    }

    public void stop() {
        if (this.bStarted) {
            this.timer.cancel();
            this.timer = null;
            this.bStarted = false;
        }
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }
}

