/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util.stream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BinaryWriter
extends FilterOutputStream {
    private final byte[] writeBuffer = new byte[8];

    public BinaryWriter(OutputStream out) {
        super(out);
    }

    public void writeInt(int v) throws IOException {
        this.out.write(v & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 24 & 0xFF);
    }

    public void writeShort(short v) throws IOException {
        this.out.write(v & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
    }

    public void writeLong(long v) throws IOException {
        this.writeBuffer[7] = (byte)(v >>> 56);
        this.writeBuffer[6] = (byte)(v >>> 48);
        this.writeBuffer[5] = (byte)(v >>> 40);
        this.writeBuffer[4] = (byte)(v >>> 32);
        this.writeBuffer[3] = (byte)(v >>> 24);
        this.writeBuffer[2] = (byte)(v >>> 16);
        this.writeBuffer[1] = (byte)(v >>> 8);
        this.writeBuffer[0] = (byte)v;
        this.out.write(this.writeBuffer, 0, 8);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBoolean(boolean v) throws IOException {
        this.out.write(v ? 1 : 0);
    }

    public void writeByte(byte v) throws IOException {
        this.out.write(v);
    }

    public void writeChar(char v) throws IOException {
        this.out.write(v);
    }
}

