/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.networking.steam3;

import in.dragonbra.javasteam.networking.steam3.Connection;
import in.dragonbra.javasteam.networking.steam3.NetMsgEventArgs;
import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.networking.steam3.WebSocketCMClient;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;

public class WebSocketConnection
extends Connection
implements WebSocketCMClient.WSListener {
    private static final Logger logger = LogManager.getLogger(WebSocketConnection.class);
    private final AtomicReference<WebSocketCMClient> client = new AtomicReference<Object>(null);
    private volatile boolean userInitiated = false;
    private InetSocketAddress socketEndPoint;

    @Override
    public void connect(InetSocketAddress endPoint, int timeout) {
        logger.debug("Connecting to " + endPoint + "...");
        WebSocketCMClient newClient = new WebSocketCMClient(WebSocketConnection.getUri(endPoint), timeout, this);
        WebSocketCMClient oldClient = this.client.getAndSet(newClient);
        if (oldClient != null) {
            logger.debug("Attempted to connect while already connected. Closing old connection...");
            oldClient.close();
        }
        this.socketEndPoint = endPoint;
        newClient.connect();
    }

    @Override
    public void disconnect() {
        this.disconnectCore(true);
    }

    @Override
    public void send(byte[] data) {
        try {
            this.client.get().send(data);
        }
        catch (Exception e) {
            logger.debug("Exception while sending data", e);
            this.disconnectCore(false);
        }
    }

    @Override
    public InetAddress getLocalIP() {
        return this.client.get().getLocalSocketAddress().getAddress();
    }

    @Override
    public InetSocketAddress getCurrentEndPoint() {
        return this.socketEndPoint;
    }

    @Override
    public ProtocolTypes getProtocolTypes() {
        return ProtocolTypes.WEB_SOCKET;
    }

    private void disconnectCore(boolean userInitiated) {
        WebSocketCMClient oldClient = this.client.getAndSet(null);
        if (oldClient != null) {
            oldClient.close();
            this.userInitiated = userInitiated;
        }
        this.socketEndPoint = null;
    }

    private static URI getUri(InetSocketAddress address) {
        return URI.create("wss://" + address.getHostString() + ":" + address.getPort() + "/cmsocket/");
    }

    @Override
    public void onData(byte[] data) {
        if (data != null && data.length > 0) {
            this.onNetMsgReceived(new NetMsgEventArgs(data, this.getCurrentEndPoint()));
        }
    }

    @Override
    public void onClose(boolean remote) {
        this.onDisconnected(this.userInitiated && !remote);
    }

    @Override
    public void onError(Exception ex) {
        logger.debug("error in websocket", ex);
    }

    @Override
    public void onOpen() {
        logger.debug("Connected to " + this.getCurrentEndPoint());
        this.onConnected();
    }
}

