/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.authentication;

import com.google.protobuf.ByteString;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient;
import in.dragonbra.javasteam.steam.authentication.AuthPollResult;
import in.dragonbra.javasteam.steam.authentication.AuthSession;
import in.dragonbra.javasteam.steam.authentication.AuthenticationException;
import in.dragonbra.javasteam.steam.authentication.CredentialsAuthSession;
import in.dragonbra.javasteam.steam.authentication.IAuthenticator;
import in.dragonbra.javasteam.steam.authentication.SteamAuthentication;
import in.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0010\u00a2\u0006\u0002\b#J\n\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0019\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J\u0006\u0010*\u001a\u00020%J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002R*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006-"}, d2={"Lin/dragonbra/javasteam/steam/authentication/AuthSession;", "", "authentication", "Lin/dragonbra/javasteam/steam/authentication/SteamAuthentication;", "authenticator", "Lin/dragonbra/javasteam/steam/authentication/IAuthenticator;", "clientId", "", "requestId", "", "allowedConfirmations", "", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesAuthSteamclient$CAuthentication_AllowedConfirmation;", "pollingInterval", "", "(Lin/dragonbra/javasteam/steam/authentication/SteamAuthentication;Lin/dragonbra/javasteam/steam/authentication/IAuthenticator;J[BLjava/util/List;F)V", "<set-?>", "getAllowedConfirmations", "()Ljava/util/List;", "getAuthentication", "()Lin/dragonbra/javasteam/steam/authentication/SteamAuthentication;", "getAuthenticator", "()Lin/dragonbra/javasteam/steam/authentication/IAuthenticator;", "clientID", "getClientID", "()J", "getPollingInterval", "()F", "requestID", "getRequestID", "()[B", "handlePollAuthSessionStatusResponse", "", "response", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesAuthSteamclient$CAuthentication_PollAuthSessionStatus_Response$Builder;", "handlePollAuthSessionStatusResponse$javasteam", "pollAuthSessionStatus", "Lin/dragonbra/javasteam/steam/authentication/AuthPollResult;", "pollingWaitForResult", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pollingWaitForResultCompat", "sortConfirmations", "confirmations", "javasteam"})
@SourceDebugExtension(value={"SMAP\nAuthSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthSession.kt\nin/dragonbra/javasteam/steam/authentication/AuthSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,281:1\n1179#2,2:282\n1253#2,4:284\n1045#2:288\n*S KotlinDebug\n*F\n+ 1 AuthSession.kt\nin/dragonbra/javasteam/steam/authentication/AuthSession\n*L\n275#1:282,2\n275#1:284,4\n277#1:288\n*E\n"})
public class AuthSession {
    @NotNull
    private SteamAuthentication authentication;
    @NotNull
    private List<SteammessagesAuthSteamclient.CAuthentication_AllowedConfirmation> allowedConfirmations;
    @Nullable
    private IAuthenticator authenticator;
    private long clientID;
    @NotNull
    private byte[] requestID;
    private float pollingInterval;

    public AuthSession(@NotNull SteamAuthentication authentication, @Nullable IAuthenticator authenticator, long clientId, @NotNull byte[] requestId, @NotNull List<SteammessagesAuthSteamclient.CAuthentication_AllowedConfirmation> allowedConfirmations, float pollingInterval) {
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter(allowedConfirmations, (String)"allowedConfirmations");
        this.allowedConfirmations = this.sortConfirmations(allowedConfirmations);
        this.authentication = authentication;
        this.authenticator = authenticator;
        this.clientID = clientId;
        this.pollingInterval = pollingInterval;
        this.requestID = requestId;
    }

    @NotNull
    public final SteamAuthentication getAuthentication() {
        return this.authentication;
    }

    @NotNull
    public final List<SteammessagesAuthSteamclient.CAuthentication_AllowedConfirmation> getAllowedConfirmations() {
        return this.allowedConfirmations;
    }

    @Nullable
    public final IAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public final long getClientID() {
        return this.clientID;
    }

    @NotNull
    public final byte[] getRequestID() {
        return this.requestID;
    }

    public final float getPollingInterval() {
        return this.pollingInterval;
    }

    @NotNull
    public final AuthPollResult pollingWaitForResultCompat() throws UnsupportedOperationException, AuthenticationException, NotImplementedError, NullPointerException, IllegalStateException, CancellationException {
        return (AuthPollResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AuthPollResult>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AuthSession this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                        this.label = 1;
                        Object object3 = this.this$0.pollingWaitForResult($this$runBlocking, (Continuation<? super AuthPollResult>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super AuthPollResult>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super AuthPollResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object pollingWaitForResult(@NotNull CoroutineScope var1_1, @NotNull Continuation<? super AuthPollResult> var2_2) throws AuthenticationException, CancellationException, IllegalStateException, NotImplementedError, NullPointerException, UnsupportedOperationException {
        if (!(var2_2 instanceof pollingWaitForResult.1)) ** GOTO lbl-1000
        var13_3 = var2_2;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AuthSession this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.pollingWaitForResult(null, (Continuation<? super AuthPollResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                pollLoop = false;
                preferredConfirmation = (SteammessagesAuthSteamclient.CAuthentication_AllowedConfirmation)CollectionsKt.firstOrNull(this.allowedConfirmations);
                if (preferredConfirmation == null || preferredConfirmation.getConfirmationType() == SteammessagesAuthSteamclient.EAuthSessionGuardType.k_EAuthSessionGuardType_Unknown) {
                    throw new IllegalStateException("There are no allowed confirmations");
                }
                if (this.authenticator != null && preferredConfirmation.getConfirmationType() == SteammessagesAuthSteamclient.EAuthSessionGuardType.k_EAuthSessionGuardType_DeviceConfirmation) {
                    v0 = this.authenticator;
                    Intrinsics.checkNotNull((Object)v0);
                    prefersToPollForConfirmation = v0.acceptDeviceConfirmation().get();
                    if (!prefersToPollForConfirmation.booleanValue()) {
                        if (this.allowedConfirmations.size() <= 1) {
                            throw new IllegalStateException("AcceptDeviceConfirmation returned false which indicates a fallback to another confirmation type, but there are no other confirmation types available.");
                        }
                        preferredConfirmation = this.allowedConfirmations.get(1);
                    }
                }
                v1 = preferredConfirmation.getConfirmationType();
                switch (v1 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v1.ordinal()]) {
                    case 3: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        v2 = this instanceof CredentialsAuthSession != false ? (CredentialsAuthSession)this : null;
                        if (v2 == null) {
                            throw new IllegalStateException("Got " + (Object)preferredConfirmation.getConfirmationType() + " confirmation type in a session that is not CredentialsAuthSession.");
                        }
                        credentialsAuthSession = v2;
                        if (this.authenticator == null) {
                            throw new NullPointerException("This account requires an authenticator for login, but none was provided in 'AuthSessionDetails'.");
                        }
                        v3 = preferredConfirmation.getConfirmationType();
                        switch (v3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v3.ordinal()]) {
                            case 1: {
                                v4 = EResult.InvalidLoginAuthCode;
                                break;
                            }
                            case 2: {
                                v4 = EResult.TwoFactorCodeMismatch;
                                break;
                            }
                            default: {
                                throw new NotImplementedError(null, 1, null);
                            }
                        }
                        expectedInvalidCodeResult = v4;
                        previousCodeWasIncorrect = false;
                        waitingForValidCode = true;
                        while (waitingForValidCode) {
                            try {
                                v5 = preferredConfirmation.getConfirmationType();
                                switch (v5 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v5.ordinal()]) {
                                    case 1: {
                                        v6 = this.authenticator;
                                        Intrinsics.checkNotNull((Object)v6);
                                        v7 = v6.getEmailCode(preferredConfirmation.getAssociatedMessage(), previousCodeWasIncorrect != false).get();
                                        break;
                                    }
                                    case 2: {
                                        v8 = this.authenticator;
                                        Intrinsics.checkNotNull((Object)v8);
                                        v7 = v8.getDeviceCode(previousCodeWasIncorrect != false).get();
                                        break;
                                    }
                                    default: {
                                        throw new NotImplementedError(null, 1, null);
                                    }
                                }
                                task = v7;
                                var11_15 = task;
                                if (var11_15 == null || var11_15.length() == 0) {
                                    throw new IllegalStateException("No code was provided by the authenticator.");
                                }
                                credentialsAuthSession.sendSteamGuardCode(task, preferredConfirmation.getConfirmationType());
                                waitingForValidCode = false;
                            }
                            catch (AuthenticationException e) {
                                if (e.getResult() != expectedInvalidCodeResult) continue;
                                previousCodeWasIncorrect = true;
                            }
                        }
                        break;
                    }
                    case 4: {
                        pollLoop = true;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported confirmation type " + (Object)preferredConfirmation.getConfirmationType() + '.');
                    }
                }
                if (!pollLoop) {
                    v9 = this.pollAuthSessionStatus();
                    if (v9 == null) {
                        throw new AuthenticationException("Authentication failed", EResult.Fail);
                    }
                    return v9;
                }
                pollResponse = null;
lbl88:
                // 3 sources

                while (pollResponse == null) {
                    CoroutineScopeKt.ensureActive((CoroutineScope)coroutineScope);
                    pollResponse = this.pollAuthSessionStatus();
                    $continuation.L$0 = this;
                    $continuation.L$1 = coroutineScope;
                    $continuation.L$2 = pollResponse;
                    $continuation.label = 1;
                    v10 = DelayKt.delay((long)((long)this.pollingInterval), (Continuation)$continuation);
                    if (v10 != var14_5) continue;
                    return var14_5;
                }
                break;
            }
            case 1: {
                pollResponse = (AuthPollResult)$continuation.L$2;
                coroutineScope = (CoroutineScope)$continuation.L$1;
                this = (AuthSession)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
                ** GOTO lbl88
            }
        }
        return pollResponse;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final AuthPollResult pollAuthSessionStatus() {
        SteammessagesAuthSteamclient.CAuthentication_PollAuthSessionStatus_Request.Builder request = SteammessagesAuthSteamclient.CAuthentication_PollAuthSessionStatus_Request.newBuilder();
        request.setClientId(this.clientID);
        request.setRequestId(ByteString.copyFrom((byte[])this.requestID));
        ServiceMethodResponse message = this.authentication.getAuthenticationService$javasteam().PollAuthSessionStatus(request.build()).runBlock();
        if (message.getResult() != EResult.OK) {
            EResult eResult = message.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)eResult), (String)"getResult(...)");
            throw new AuthenticationException("Failed to poll status", eResult);
        }
        Object t = message.getDeserializedResponse(SteammessagesAuthSteamclient.CAuthentication_PollAuthSessionStatus_Response.class);
        Intrinsics.checkNotNullExpressionValue(t, (String)"getDeserializedResponse(...)");
        SteammessagesAuthSteamclient.CAuthentication_PollAuthSessionStatus_Response.Builder response = (SteammessagesAuthSteamclient.CAuthentication_PollAuthSessionStatus_Response.Builder)t;
        if (response.getNewClientId() > 0L) {
            this.clientID = response.getNewClientId();
        }
        this.handlePollAuthSessionStatusResponse$javasteam(response);
        String string = response.getRefreshToken();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRefreshToken(...)");
        if (((CharSequence)string).length() > 0) {
            return new AuthPollResult(response);
        }
        return null;
    }

    public void handlePollAuthSessionStatusResponse$javasteam(@NotNull SteammessagesAuthSteamclient.CAuthentication_PollAuthSessionStatus_Response.Builder response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.getNewClientId() != 0L) {
            this.clientID = response.getNewClientId();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<SteammessagesAuthSteamclient.CAuthentication_AllowedConfirmation> sortConfirmations(List<SteammessagesAuthSteamclient.CAuthentication_AllowedConfirmation> confirmations) {
        void $this$associateTo$iv$iv;
        SteammessagesAuthSteamclient.EAuthSessionGuardType[] eAuthSessionGuardTypeArray = new SteammessagesAuthSteamclient.EAuthSessionGuardType[]{SteammessagesAuthSteamclient.EAuthSessionGuardType.k_EAuthSessionGuardType_None, SteammessagesAuthSteamclient.EAuthSessionGuardType.k_EAuthSessionGuardType_DeviceConfirmation, SteammessagesAuthSteamclient.EAuthSessionGuardType.k_EAuthSessionGuardType_DeviceCode, SteammessagesAuthSteamclient.EAuthSessionGuardType.k_EAuthSessionGuardType_EmailCode, SteammessagesAuthSteamclient.EAuthSessionGuardType.k_EAuthSessionGuardType_EmailConfirmation, SteammessagesAuthSteamclient.EAuthSessionGuardType.k_EAuthSessionGuardType_MachineToken, SteammessagesAuthSteamclient.EAuthSessionGuardType.k_EAuthSessionGuardType_Unknown};
        SteammessagesAuthSteamclient.EAuthSessionGuardType[] preferredConfirmationTypes = eAuthSessionGuardTypeArray;
        Iterable $this$associate$iv = ArraysKt.withIndex((Object[])preferredConfirmationTypes);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            boolean bl = false;
            int index = indexedValue.component1();
            SteammessagesAuthSteamclient.EAuthSessionGuardType value = (SteammessagesAuthSteamclient.EAuthSessionGuardType)((Object)indexedValue.component2());
            indexedValue = TuplesKt.to((Object)((Object)value), (Object)index);
            map.put(indexedValue.getFirst(), indexedValue.getSecond());
        }
        Map sortOrder = destination$iv$iv;
        Iterable $this$sortedBy$iv = confirmations;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(sortOrder){
            final /* synthetic */ Map $sortOrder$inlined;
            {
                this.$sortOrder$inlined = map;
            }

            public final int compare(T a, T b) {
                SteammessagesAuthSteamclient.CAuthentication_AllowedConfirmation x = (SteammessagesAuthSteamclient.CAuthentication_AllowedConfirmation)a;
                boolean bl = false;
                Integer n = (Integer)this.$sortOrder$inlined.get((Object)((Object)x.getConfirmationType()));
                x = (SteammessagesAuthSteamclient.CAuthentication_AllowedConfirmation)b;
                Comparable comparable = Integer.valueOf(n != null ? n : Integer.MAX_VALUE);
                bl = false;
                Integer n2 = (Integer)this.$sortOrder$inlined.get((Object)((Object)x.getConfirmationType()));
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(n2 != null ? n2 : Integer.MAX_VALUE));
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SteammessagesAuthSteamclient.EAuthSessionGuardType.values().length];
            try {
                nArray[SteammessagesAuthSteamclient.EAuthSessionGuardType.k_EAuthSessionGuardType_EmailCode.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SteammessagesAuthSteamclient.EAuthSessionGuardType.k_EAuthSessionGuardType_DeviceCode.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SteammessagesAuthSteamclient.EAuthSessionGuardType.k_EAuthSessionGuardType_None.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SteammessagesAuthSteamclient.EAuthSessionGuardType.k_EAuthSessionGuardType_DeviceConfirmation.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

