/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.authentication;

import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient;
import in.dragonbra.javasteam.steam.authentication.AuthSession;
import in.dragonbra.javasteam.steam.authentication.AuthenticationException;
import in.dragonbra.javasteam.steam.authentication.IAuthenticator;
import in.dragonbra.javasteam.steam.authentication.SteamAuthentication;
import in.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse;
import in.dragonbra.javasteam.types.SteamID;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lin/dragonbra/javasteam/steam/authentication/CredentialsAuthSession;", "Lin/dragonbra/javasteam/steam/authentication/AuthSession;", "authentication", "Lin/dragonbra/javasteam/steam/authentication/SteamAuthentication;", "authenticator", "Lin/dragonbra/javasteam/steam/authentication/IAuthenticator;", "response", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesAuthSteamclient$CAuthentication_BeginAuthSessionViaCredentials_Response$Builder;", "(Lin/dragonbra/javasteam/steam/authentication/SteamAuthentication;Lin/dragonbra/javasteam/steam/authentication/IAuthenticator;Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesAuthSteamclient$CAuthentication_BeginAuthSessionViaCredentials_Response$Builder;)V", "steamID", "Lin/dragonbra/javasteam/types/SteamID;", "sendSteamGuardCode", "", "code", "", "codeType", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesAuthSteamclient$EAuthSessionGuardType;", "javasteam"})
public final class CredentialsAuthSession
extends AuthSession {
    @NotNull
    private final SteamID steamID;

    public CredentialsAuthSession(@NotNull SteamAuthentication authentication, @Nullable IAuthenticator authenticator, @NotNull SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Response.Builder response) {
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        long l = response.getClientId();
        byte[] byArray = response.getRequestId().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        List<SteammessagesAuthSteamclient.CAuthentication_AllowedConfirmation> list = response.getAllowedConfirmationsList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllowedConfirmationsList(...)");
        super(authentication, authenticator, l, byArray, list, response.getInterval());
        this.steamID = new SteamID(response.getSteamid());
    }

    public final void sendSteamGuardCode(@Nullable String code, @Nullable SteammessagesAuthSteamclient.EAuthSessionGuardType codeType) throws AuthenticationException {
        SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Request.Builder request = SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Request.newBuilder();
        request.setClientId(this.getClientID());
        request.setSteamid(this.steamID.convertToUInt64());
        request.setCode(code);
        request.setCodeType(codeType);
        ServiceMethodResponse message = this.getAuthentication().getAuthenticationService$javasteam().UpdateAuthSessionWithSteamGuardCode(request.build()).runBlock();
        Object t = message.getDeserializedResponse(SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Response.class);
        Intrinsics.checkNotNullExpressionValue(t, (String)"getDeserializedResponse(...)");
        SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Response.Builder response = (SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Response.Builder)t;
        if (message.getResult() != EResult.OK && message.getResult() != EResult.DuplicateRequest) {
            EResult eResult = message.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)eResult), (String)"getResult(...)");
            throw new AuthenticationException("Failed to send steam guard code", eResult);
        }
        response.getAgreementSessionUrl();
    }
}

