/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.authentication;

import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.protobufs.steamclient.Enums;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient;
import in.dragonbra.javasteam.rpc.service.Authentication;
import in.dragonbra.javasteam.steam.authentication.AuthSessionDetails;
import in.dragonbra.javasteam.steam.authentication.AuthenticationException;
import in.dragonbra.javasteam.steam.authentication.CredentialsAuthSession;
import in.dragonbra.javasteam.steam.authentication.QrAuthSession;
import in.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages;
import in.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse;
import in.dragonbra.javasteam.steam.steamclient.SteamClient;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.concurrent.CancellationException;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lin/dragonbra/javasteam/steam/authentication/SteamAuthentication;", "", "steamClient", "Lin/dragonbra/javasteam/steam/steamclient/SteamClient;", "unifiedMessages", "Lin/dragonbra/javasteam/steam/handlers/steamunifiedmessages/SteamUnifiedMessages;", "(Lin/dragonbra/javasteam/steam/steamclient/SteamClient;Lin/dragonbra/javasteam/steam/handlers/steamunifiedmessages/SteamUnifiedMessages;)V", "authenticationService", "Lin/dragonbra/javasteam/rpc/service/Authentication;", "getAuthenticationService$javasteam", "()Lin/dragonbra/javasteam/rpc/service/Authentication;", "beginAuthSessionViaCredentials", "Lin/dragonbra/javasteam/steam/authentication/CredentialsAuthSession;", "authSessionDetails", "Lin/dragonbra/javasteam/steam/authentication/AuthSessionDetails;", "beginAuthSessionViaQR", "Lin/dragonbra/javasteam/steam/authentication/QrAuthSession;", "getPasswordRSAPublicKey", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesAuthSteamclient$CAuthentication_GetPasswordRSAPublicKey_Response$Builder;", "accountName", "", "javasteam"})
public final class SteamAuthentication {
    @NotNull
    private final SteamClient steamClient;
    @NotNull
    private final Authentication authenticationService;

    public SteamAuthentication(@NotNull SteamClient steamClient, @NotNull SteamUnifiedMessages unifiedMessages) {
        Intrinsics.checkNotNullParameter((Object)steamClient, (String)"steamClient");
        Intrinsics.checkNotNullParameter((Object)unifiedMessages, (String)"unifiedMessages");
        this.steamClient = steamClient;
        this.authenticationService = new Authentication(unifiedMessages);
    }

    @NotNull
    public final Authentication getAuthenticationService$javasteam() {
        return this.authenticationService;
    }

    private final SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Response.Builder getPasswordRSAPublicKey(String accountName) throws AuthenticationException {
        SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Request.Builder request = SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Request.newBuilder();
        request.setAccountName(accountName);
        ServiceMethodResponse message = this.authenticationService.GetPasswordRSAPublicKey(request.build()).runBlock();
        if (message.getResult() != EResult.OK) {
            EResult eResult = message.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)eResult), (String)"getResult(...)");
            throw new AuthenticationException("Failed to get password public key", eResult);
        }
        Object t = message.getDeserializedResponse(SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Response.class);
        Intrinsics.checkNotNullExpressionValue(t, (String)"getDeserializedResponse(...)");
        return (SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Response.Builder)t;
    }

    @NotNull
    public final QrAuthSession beginAuthSessionViaQR(@NotNull AuthSessionDetails authSessionDetails) throws AuthenticationException, CancellationException {
        Intrinsics.checkNotNullParameter((Object)authSessionDetails, (String)"authSessionDetails");
        if (!this.steamClient.isConnected()) {
            throw new IllegalArgumentException("The SteamClient instance must be connected.");
        }
        SteammessagesAuthSteamclient.CAuthentication_DeviceDetails.Builder deviceDetails = SteammessagesAuthSteamclient.CAuthentication_DeviceDetails.newBuilder();
        deviceDetails.setDeviceFriendlyName(authSessionDetails.getDeviceFriendlyName());
        deviceDetails.setPlatformType(authSessionDetails.platformType);
        deviceDetails.setOsType(authSessionDetails.clientOSType.code());
        SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaQR_Request.Builder request = SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaQR_Request.newBuilder();
        request.setWebsiteId(authSessionDetails.websiteID);
        request.setDeviceDetails(deviceDetails.build());
        ServiceMethodResponse message = this.authenticationService.BeginAuthSessionViaQR(request.build()).runBlock();
        if (message.getResult() != EResult.OK) {
            EResult eResult = message.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)eResult), (String)"getResult(...)");
            throw new AuthenticationException("Failed to begin QR auth session", eResult);
        }
        Object t = message.getDeserializedResponse(SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaQR_Response.class);
        Intrinsics.checkNotNullExpressionValue(t, (String)"getDeserializedResponse(...)");
        SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaQR_Response.Builder response = (SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaQR_Response.Builder)t;
        return new QrAuthSession(this, authSessionDetails.authenticator, response);
    }

    @NotNull
    public final CredentialsAuthSession beginAuthSessionViaCredentials(@Nullable AuthSessionDetails authSessionDetails) throws AuthenticationException {
        ServiceMethodResponse message;
        byte[] byArray;
        if (authSessionDetails == null) {
            throw new IllegalArgumentException("authSessionDetails is null");
        }
        CharSequence charSequence = authSessionDetails.username;
        if (charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)authSessionDetails.password) == null || charSequence.length() == 0) {
            throw new IllegalArgumentException("BeginAuthSessionViaCredentials requires a username and password to be set in authSessionDetails.");
        }
        if (!this.steamClient.isConnected()) {
            throw new IllegalArgumentException("The SteamClient instance must be connected.");
        }
        SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Response.Builder passwordRSAPublicKey = this.getPasswordRSAPublicKey(authSessionDetails.username);
        BigInteger publicModulus = new BigInteger(passwordRSAPublicKey.getPublickeyMod(), 16);
        BigInteger publicExponent = new BigInteger(passwordRSAPublicKey.getPublickeyExp(), 16);
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(publicModulus, publicExponent);
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(rsaPublicKeySpec);
        Cipher cipher = Cipher.getInstance("RSA/None/PKCS1Padding");
        cipher.init(1, publicKey);
        Base64.Encoder encoder = Base64.getEncoder();
        String string = authSessionDetails.password;
        if (string != null) {
            String string2 = string;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray2 = string2.getBytes(charset);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        } else {
            byArray = null;
        }
        String string3 = encoder.encodeToString(cipher.doFinal(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encodeToString(...)");
        String encryptedPassword = StringsKt.dropLast((String)string3, (int)1);
        Enums.ESessionPersistence persistentSession = authSessionDetails.persistentSession ? Enums.ESessionPersistence.k_ESessionPersistence_Persistent : Enums.ESessionPersistence.k_ESessionPersistence_Ephemeral;
        SteammessagesAuthSteamclient.CAuthentication_DeviceDetails.Builder deviceDetails = SteammessagesAuthSteamclient.CAuthentication_DeviceDetails.newBuilder();
        deviceDetails.setDeviceFriendlyName(authSessionDetails.getDeviceFriendlyName());
        deviceDetails.setOsType(authSessionDetails.clientOSType.code());
        deviceDetails.setPlatformType(authSessionDetails.platformType);
        SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Request.Builder request = SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Request.newBuilder();
        request.setAccountName(authSessionDetails.username);
        request.setDeviceDetails(deviceDetails.build());
        request.setEncryptedPassword(encryptedPassword);
        request.setEncryptionTimestamp(passwordRSAPublicKey.getTimestamp());
        request.setPersistence(persistentSession);
        request.setWebsiteId(authSessionDetails.websiteID);
        CharSequence charSequence2 = authSessionDetails.guardData;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            request.setGuardData(authSessionDetails.guardData);
        }
        if ((message = this.authenticationService.BeginAuthSessionViaCredentials(request.build()).runBlock()).getResult() != EResult.OK) {
            EResult eResult = message.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)eResult), (String)"getResult(...)");
            throw new AuthenticationException("Authentication failed", eResult);
        }
        Object t = message.getDeserializedResponse(SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Response.class);
        Intrinsics.checkNotNullExpressionValue(t, (String)"getDeserializedResponse(...)");
        SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Response.Builder response = (SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Response.Builder)t;
        return new CredentialsAuthSession(this, authSessionDetails.authenticator, response);
    }
}

