/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.discovery;

import in.dragonbra.javasteam.networking.steam3.ProtocolTypes;
import in.dragonbra.javasteam.steam.discovery.ServerInfo;
import in.dragonbra.javasteam.steam.discovery.ServerQuality;
import in.dragonbra.javasteam.steam.discovery.ServerRecord;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfiguration;
import in.dragonbra.javasteam.steam.webapi.SteamDirectory;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;

public class SmartCMServerList {
    private static final Logger logger = LogManager.getLogger(SmartCMServerList.class);
    private final SteamConfiguration configuration;
    private final List<ServerInfo> servers = Collections.synchronizedList(new ArrayList());
    private Long badConnectionMemoryTimeSpan;

    public SmartCMServerList(SteamConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        this.configuration = configuration;
    }

    private void startFetchingServers() throws IOException {
        if (!this.servers.isEmpty()) {
            return;
        }
        this.resolveServerList();
    }

    private void resolveServerList() throws IOException {
        logger.debug("Resolving server list");
        List<ServerRecord> endPoints = this.configuration.getServerListProvider().fetchServerList();
        if (endPoints == null) {
            endPoints = new ArrayList<ServerRecord>();
        }
        if (endPoints.isEmpty() && this.configuration.isAllowDirectoryFetch()) {
            logger.debug("Server list provider had no entries, will query SteamDirectory");
            endPoints = SteamDirectory.load(this.configuration);
        }
        if (endPoints.isEmpty() && this.configuration.isAllowDirectoryFetch()) {
            logger.debug("Could not query SteamDirectory, falling back to cm2-ord1");
            InetSocketAddress cm0 = new InetSocketAddress("cm2-ord1.cm.steampowered.com", 27017);
            endPoints.add(ServerRecord.createSocketServer(cm0));
        }
        logger.debug("Resolved " + endPoints.size() + " servers");
        this.replaceList(endPoints);
    }

    public void resetOldScores() {
        if (this.badConnectionMemoryTimeSpan == null) {
            return;
        }
        long cutoff = System.currentTimeMillis() - this.badConnectionMemoryTimeSpan;
        for (ServerInfo serverInfo : this.servers) {
            if (serverInfo.getLastBadConnection() == null || serverInfo.getLastBadConnection().getTime() >= cutoff) continue;
            serverInfo.setLastBadConnection(null);
        }
    }

    public void replaceList(List<ServerRecord> endPoints) {
        if (endPoints == null) {
            throw new IllegalArgumentException("endPoints is null");
        }
        this.servers.clear();
        for (ServerRecord endPoint : endPoints) {
            this.addCore(endPoint);
        }
        this.configuration.getServerListProvider().updateServerList(endPoints);
    }

    private void addCore(ServerRecord endPoint) {
        for (ProtocolTypes protocol : endPoint.getProtocolTypes()) {
            this.servers.add(new ServerInfo(endPoint, protocol));
        }
    }

    public void resetBadServers() {
        for (ServerInfo serverInfo : this.servers) {
            serverInfo.setLastBadConnection(null);
        }
    }

    public boolean tryMark(InetSocketAddress endPoint, ProtocolTypes protocolTypes, ServerQuality quality) {
        return this.tryMark(endPoint, EnumSet.of(protocolTypes), quality);
    }

    public boolean tryMark(InetSocketAddress endPoint, EnumSet<ProtocolTypes> protocolTypes, ServerQuality quality) {
        ArrayList<ServerInfo> serverInfos = new ArrayList<ServerInfo>();
        for (ServerInfo x : this.servers) {
            if (!x.getRecord().getEndpoint().equals(endPoint) || !protocolTypes.contains((Object)x.getProtocol())) continue;
            serverInfos.add(x);
        }
        for (ServerInfo serverInfo : serverInfos) {
            logger.debug("Marking " + serverInfo.getRecord().getEndpoint() + " - " + (Object)((Object)serverInfo.getProtocol()) + " as " + (Object)((Object)quality));
            this.markServerCore(serverInfo, quality);
        }
        return serverInfos.size() > 0;
    }

    private void markServerCore(ServerInfo serverInfo, ServerQuality quality) {
        switch (quality) {
            case GOOD: {
                serverInfo.setLastBadConnection(null);
                break;
            }
            case BAD: {
                serverInfo.setLastBadConnection(new Date());
            }
        }
    }

    private ServerRecord getNextServerCandidateInternal(EnumSet<ProtocolTypes> supportedProtocolTypes) {
        this.resetOldScores();
        ArrayList<ServerInfo> serverInfos = new ArrayList<ServerInfo>();
        for (ServerInfo serverInfo : this.servers) {
            if (!supportedProtocolTypes.contains((Object)serverInfo.getProtocol())) continue;
            serverInfos.add(serverInfo);
        }
        serverInfos.sort((o1, o2) -> {
            if (o1.getLastBadConnection() == null && o2.getLastBadConnection() == null) {
                return 1;
            }
            if (o1.getLastBadConnection() == null) {
                return -1;
            }
            if (o2.getLastBadConnection() == null) {
                return 1;
            }
            return o1.getLastBadConnection().before(o2.getLastBadConnection()) ? -1 : 1;
        });
        if (serverInfos.isEmpty()) {
            return null;
        }
        ServerInfo result = (ServerInfo)serverInfos.get(0);
        return new ServerRecord(result.getRecord().getEndpoint(), result.getProtocol());
    }

    public ServerRecord getNextServerCandidate(EnumSet<ProtocolTypes> supportedProtocolTypes) {
        try {
            this.startFetchingServers();
        }
        catch (IOException e) {
            return null;
        }
        return this.getNextServerCandidateInternal(supportedProtocolTypes);
    }

    public ServerRecord getNextServerCandidate(ProtocolTypes supportedProtocolTypes) {
        return this.getNextServerCandidate(EnumSet.of(supportedProtocolTypes));
    }

    public List<ServerRecord> getAllEndPoints() {
        try {
            this.startFetchingServers();
        }
        catch (IOException e) {
            return new ArrayList<ServerRecord>();
        }
        ArrayList<ServerRecord> serverRecords = new ArrayList<ServerRecord>();
        for (ServerInfo server : this.servers) {
            ServerRecord record = server.getRecord();
            if (serverRecords.contains(record)) continue;
            serverRecords.add(record);
        }
        return serverRecords;
    }

    public long getBadConnectionMemoryTimeSpan() {
        return this.badConnectionMemoryTimeSpan;
    }

    public void setBadConnectionMemoryTimeSpan(long badConnectionMemoryTimeSpan) {
        this.badConnectionMemoryTimeSpan = badConnectionMemoryTimeSpan;
    }
}

