/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamapps.callback;

import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.generated.MsgClientUpdateGuestPassesList;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.KeyValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class GuestPassListCallback
extends CallbackMsg {
    private final EResult result;
    private final int countGuestPassesToGive;
    private final int countGuestPassesToRedeem;
    private final List<KeyValue> guestPasses;

    public GuestPassListCallback(MsgClientUpdateGuestPassesList msg, InputStream payload) {
        this.result = msg.getResult();
        this.countGuestPassesToGive = msg.getCountGuestPassesToGive();
        this.countGuestPassesToRedeem = msg.getCountGuestPassesToRedeem();
        this.guestPasses = new ArrayList<KeyValue>();
        try {
            for (int i = 0; i < this.countGuestPassesToGive + this.countGuestPassesToRedeem; ++i) {
                KeyValue kv = new KeyValue();
                kv.tryReadAsBinary(payload);
                this.guestPasses.add(kv);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("failed to read guest passes", e);
        }
    }

    public EResult getResult() {
        return this.result;
    }

    public int getCountGuestPassesToGive() {
        return this.countGuestPassesToGive;
    }

    public int getCountGuestPassesToRedeem() {
        return this.countGuestPassesToRedeem;
    }

    public List<KeyValue> getGuestPasses() {
        return this.guestPasses;
    }
}

