/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamapps.callback;

import in.dragonbra.javasteam.enums.EPurchaseResultDetail;
import in.dragonbra.javasteam.enums.EResult;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.types.KeyValue;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import java.io.IOException;

public class PurchaseResponseCallback
extends CallbackMsg {
    private final EResult result;
    private final EPurchaseResultDetail purchaseResultDetail;
    private final KeyValue purchaseReceiptInfo;

    public PurchaseResponseCallback(JobID jobID, SteammessagesClientserver2.CMsgClientPurchaseResponse.Builder msg) {
        this.setJobID(jobID);
        this.result = EResult.from(msg.getEresult());
        this.purchaseResultDetail = EPurchaseResultDetail.from(msg.getPurchaseResultDetails());
        this.purchaseReceiptInfo = new KeyValue();
        if (msg.getPurchaseReceiptInfo() == null) {
            return;
        }
        try {
            MemoryStream ms = new MemoryStream(msg.getPurchaseReceiptInfo().toByteArray());
            this.purchaseReceiptInfo.tryReadAsBinary(ms);
        }
        catch (IOException exception) {
            throw new IllegalArgumentException("input stream is null");
        }
    }

    public EResult getResult() {
        return this.result;
    }

    public EPurchaseResultDetail getPurchaseResultDetail() {
        return this.purchaseResultDetail;
    }

    public KeyValue getPurchaseReceiptInfo() {
        return this.purchaseReceiptInfo;
    }
}

