/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamfriends;

import in.dragonbra.javasteam.enums.EClientPersonaStateFlag;
import in.dragonbra.javasteam.enums.EPersonaState;
import in.dragonbra.javasteam.enums.EPersonaStateFlag;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverFriends;
import in.dragonbra.javasteam.types.GameID;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.NetHelpers;
import java.net.InetAddress;
import java.util.Date;
import java.util.EnumSet;

public class PersonaState {
    private final EnumSet<EClientPersonaStateFlag> statusFlags;
    private final SteamID friendID;
    private final EPersonaState state;
    private final EnumSet<EPersonaStateFlag> stateFlags;
    private final int gameAppID;
    private final GameID gameID;
    private final String gameName;
    private final InetAddress gameServerIP;
    private final int gameServerPort;
    private final int queryPort;
    private final SteamID sourceSteamID;
    private final byte[] gameDataBlob;
    private final String name;
    private final byte[] avatarHash;
    private final Date lastLogOff;
    private final Date lastLogOn;
    private final int clanRank;
    private final String clanTag;
    private final int onlineSessionInstances;

    public PersonaState(SteammessagesClientserverFriends.CMsgClientPersonaState.Friend friend) {
        this.statusFlags = EClientPersonaStateFlag.from(friend.getPersonaStateFlags());
        this.friendID = new SteamID(friend.getFriendid());
        this.state = EPersonaState.from(friend.getPersonaState());
        this.stateFlags = EPersonaStateFlag.from(friend.getPersonaStateFlags());
        this.gameAppID = friend.getGamePlayedAppId();
        this.gameID = new GameID(friend.getGameid());
        this.gameName = friend.getGameName();
        this.gameServerIP = NetHelpers.getIPAddress(friend.getGameServerIp());
        this.gameServerPort = friend.getGameServerPort();
        this.queryPort = friend.getQueryPort();
        this.sourceSteamID = new SteamID(friend.getSteamidSource());
        this.gameDataBlob = friend.getGameDataBlob().toByteArray();
        this.name = friend.getPlayerName();
        this.avatarHash = friend.getAvatarHash().toByteArray();
        this.lastLogOff = new Date((long)friend.getLastLogoff() * 1000L);
        this.lastLogOn = new Date((long)friend.getLastLogon() * 1000L);
        this.clanRank = friend.getClanRank();
        this.clanTag = friend.getClanTag();
        this.onlineSessionInstances = friend.getOnlineSessionInstances();
    }

    public EnumSet<EClientPersonaStateFlag> getStatusFlags() {
        return this.statusFlags;
    }

    public SteamID getFriendID() {
        return this.friendID;
    }

    public EPersonaState getState() {
        return this.state;
    }

    public EnumSet<EPersonaStateFlag> getStateFlags() {
        return this.stateFlags;
    }

    public int getGameAppID() {
        return this.gameAppID;
    }

    public GameID getGameID() {
        return this.gameID;
    }

    public String getGameName() {
        return this.gameName;
    }

    public InetAddress getGameServerIP() {
        return this.gameServerIP;
    }

    public int getGameServerPort() {
        return this.gameServerPort;
    }

    public int getQueryPort() {
        return this.queryPort;
    }

    public SteamID getSourceSteamID() {
        return this.sourceSteamID;
    }

    public byte[] getGameDataBlob() {
        return this.gameDataBlob;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getAvatarHash() {
        return this.avatarHash;
    }

    public Date getLastLogOff() {
        return this.lastLogOff;
    }

    public Date getLastLogOn() {
        return this.lastLogOn;
    }

    public int getClanRank() {
        return this.clanRank;
    }

    public String getClanTag() {
        return this.clanTag;
    }

    public int getOnlineSessionInstances() {
        return this.onlineSessionInstances;
    }
}

