/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamgamecoordinator;

import com.google.protobuf.ByteString;
import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IClientGCMsg;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.steam.handlers.steamgamecoordinator.callback.MessageCallback;
import in.dragonbra.javasteam.util.MsgUtil;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SteamGameCoordinator
extends ClientMsgHandler {
    private Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamGameCoordinator() {
        this.dispatchMap.put(EMsg.ClientFromGC, this::handleFromGC);
        this.dispatchMap = Collections.unmodifiableMap(this.dispatchMap);
    }

    public void send(IClientGCMsg msg, int appId) {
        if (msg == null) {
            throw new IllegalArgumentException("msg is null");
        }
        ClientMsgProtobuf clientMsg = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgGCClient.class, EMsg.ClientToGC);
        clientMsg.getProtoHeader().setRoutingAppid(appId);
        ((SteammessagesClientserver2.CMsgGCClient.Builder)clientMsg.getBody()).setMsgtype(MsgUtil.makeGCMsg(msg.getMsgType(), msg.isProto()));
        ((SteammessagesClientserver2.CMsgGCClient.Builder)clientMsg.getBody()).setAppid(appId);
        ((SteammessagesClientserver2.CMsgGCClient.Builder)clientMsg.getBody()).setPayload(ByteString.copyFrom((byte[])msg.serialize()));
        this.client.send(clientMsg);
    }

    @Override
    public void handleMsg(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            throw new IllegalArgumentException("packetMsg is null");
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
    }

    private void handleFromGC(IPacketMsg packetMsg) {
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserver2.CMsgGCClient.class, packetMsg);
        this.client.postCallback(new MessageCallback(msg.getTargetJobID(), (SteammessagesClientserver2.CMsgGCClient.Builder)msg.getBody()));
    }
}

