/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamnetworking;

import com.google.protobuf.ByteString;
import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import in.dragonbra.javasteam.steam.handlers.steamnetworking.callback.NetworkingCertificateCallback;
import in.dragonbra.javasteam.types.AsyncJobSingle;
import in.dragonbra.javasteam.util.compat.Consumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SteamNetworking
extends ClientMsgHandler {
    private Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamNetworking() {
        this.dispatchMap.put(EMsg.ClientNetworkingCertRequestResponse, this::handleNetworkingCertRequestResponse);
        this.dispatchMap = Collections.unmodifiableMap(this.dispatchMap);
    }

    public AsyncJobSingle<NetworkingCertificateCallback> requestNetworkingCertificate(int appId, byte[] publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("publicKey is null");
        }
        ClientMsgProtobuf msg = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientNetworkingCertRequest.class, EMsg.ClientNetworkingCertRequest);
        msg.setSourceJobID(this.client.getNextJobID());
        ((SteammessagesClientserver.CMsgClientNetworkingCertRequest.Builder)msg.getBody()).setAppId(appId);
        ((SteammessagesClientserver.CMsgClientNetworkingCertRequest.Builder)msg.getBody()).setKeyData(ByteString.copyFrom((byte[])publicKey));
        this.client.send(msg);
        return new AsyncJobSingle<NetworkingCertificateCallback>(this.client, msg.getSourceJobID());
    }

    @Override
    public void handleMsg(IPacketMsg packetMsg) {
        if (packetMsg == null) {
            throw new IllegalArgumentException("packetMsg is null");
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
    }

    void handleNetworkingCertRequestResponse(IPacketMsg packetMsg) {
        ClientMsgProtobuf resp = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientNetworkingCertReply.class, packetMsg);
        NetworkingCertificateCallback callback = new NetworkingCertificateCallback(resp.getTargetJobID(), (SteammessagesClientserver.CMsgClientNetworkingCertReply.Builder)resp.getBody());
        this.client.postCallback(callback);
    }
}

