/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamtrading.callback;

import in.dragonbra.javasteam.enums.EEconTradeResponse;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver2;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.SteamID;

public class TradeResultCallback
extends CallbackMsg {
    private final int tradeID;
    private final EEconTradeResponse response;
    private final SteamID otherClient;
    private final int numDaysSteamGuardRequired;
    private final int numDaysNewDeviceCooldown;
    private final int defaultNumDaysPasswordResetProbation;
    private final int numDaysPasswordResetProbation;

    public TradeResultCallback(SteammessagesClientserver2.CMsgTrading_InitiateTradeResponse.Builder msg) {
        this.tradeID = msg.getTradeRequestId();
        this.response = EEconTradeResponse.from(msg.getResponse());
        this.otherClient = new SteamID(msg.getOtherSteamid());
        this.numDaysSteamGuardRequired = msg.getSteamguardRequiredDays();
        this.numDaysNewDeviceCooldown = msg.getNewDeviceCooldownDays();
        this.defaultNumDaysPasswordResetProbation = msg.getDefaultPasswordResetProbationDays();
        this.numDaysPasswordResetProbation = msg.getPasswordResetProbationDays();
    }

    public int getTradeID() {
        return this.tradeID;
    }

    public EEconTradeResponse getResponse() {
        return this.response;
    }

    public SteamID getOtherClient() {
        return this.otherClient;
    }

    public int getNumDaysSteamGuardRequired() {
        return this.numDaysSteamGuardRequired;
    }

    public int getNumDaysNewDeviceCooldown() {
        return this.numDaysNewDeviceCooldown;
    }

    public int getDefaultNumDaysPasswordResetProbation() {
        return this.defaultNumDaysPasswordResetProbation;
    }

    public int getNumDaysPasswordResetProbation() {
        return this.numDaysPasswordResetProbation;
    }
}

