/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.steamclient;

import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.AsyncJob;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.util.event.ScheduledFunction;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0015J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0006J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lin/dragonbra/javasteam/steam/steamclient/AsyncJobManager;", "", "()V", "asyncJobs", "Ljava/util/concurrent/ConcurrentMap;", "Lin/dragonbra/javasteam/types/JobID;", "Lin/dragonbra/javasteam/types/AsyncJob;", "getAsyncJobs", "()Ljava/util/concurrent/ConcurrentMap;", "jobTimeoutFunc", "Lin/dragonbra/javasteam/util/event/ScheduledFunction;", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "kotlin.jvm.PlatformType", "cancelPendingJobs", "", "cancelTimedOutJobs", "failJob", "jobID", "getJob", "andRemove", "", "heartbeatJob", "setTimeoutsEnabled", "enable", "startJob", "asyncJob", "tryCompleteJob", "callback", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "javasteam"})
@SourceDebugExtension(value={"SMAP\nAsyncJobManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncJobManager.kt\nin/dragonbra/javasteam/steam/steamclient/AsyncJobManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1855#2,2:137\n1855#2,2:139\n*S KotlinDebug\n*F\n+ 1 AsyncJobManager.kt\nin/dragonbra/javasteam/steam/steamclient/AsyncJobManager\n*L\n83#1:137,2\n107#1:139,2\n*E\n"})
public final class AsyncJobManager {
    @NotNull
    private final ConcurrentMap<JobID, AsyncJob> asyncJobs = new ConcurrentHashMap();
    @NotNull
    private final ScheduledFunction jobTimeoutFunc = new ScheduledFunction(this::cancelTimedOutJobs, 1000L);
    private final Logger logger = LogManager.getLogger(AsyncJobManager.class);

    @NotNull
    public final ConcurrentMap<JobID, AsyncJob> getAsyncJobs() {
        return this.asyncJobs;
    }

    public final void startJob(@NotNull AsyncJob asyncJob) {
        Intrinsics.checkNotNullParameter((Object)asyncJob, (String)"asyncJob");
        ((Map)this.asyncJobs).put(asyncJob.getJobID(), asyncJob);
    }

    public final void tryCompleteJob(@NotNull JobID jobID, @Nullable CallbackMsg callback) {
        Intrinsics.checkNotNullParameter((Object)jobID, (String)"jobID");
        AsyncJob asyncJob = AsyncJobManager.getJob$default(this, jobID, false, 2, null);
        if (asyncJob == null) {
            return;
        }
        AsyncJob asyncJob2 = asyncJob;
        boolean jobFinished = asyncJob2.addResult(callback);
        if (jobFinished) {
            this.asyncJobs.remove(jobID);
        }
    }

    public final void heartbeatJob(@NotNull JobID jobID) {
        Intrinsics.checkNotNullParameter((Object)jobID, (String)"jobID");
        AsyncJob asyncJob = AsyncJobManager.getJob$default(this, jobID, false, 2, null);
        if (asyncJob == null) {
            return;
        }
        AsyncJob asyncJob2 = asyncJob;
        asyncJob2.heartbeat();
    }

    public final void failJob(@NotNull JobID jobID) {
        Intrinsics.checkNotNullParameter((Object)jobID, (String)"jobID");
        this.logger.debug("Failing job id: " + jobID);
        AsyncJob asyncJob = this.getJob(jobID, true);
        if (asyncJob == null) {
            return;
        }
        AsyncJob asyncJob2 = asyncJob;
        asyncJob2.setFailed(true);
    }

    public final void cancelPendingJobs() {
        Iterable $this$forEach$iv = this.asyncJobs.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AsyncJob job = (AsyncJob)element$iv;
            boolean bl = false;
            job.setFailed(false);
        }
        this.asyncJobs.clear();
    }

    public final void setTimeoutsEnabled(boolean enable) {
        if (enable) {
            this.jobTimeoutFunc.start();
        } else {
            this.jobTimeoutFunc.stop();
        }
    }

    private final void cancelTimedOutJobs() {
        Iterable $this$forEach$iv = this.asyncJobs.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AsyncJob job = (AsyncJob)element$iv;
            boolean bl = false;
            if (!job.isTimedOut()) continue;
            job.setFailed(false);
            this.asyncJobs.remove(job.getJobID());
        }
    }

    private final AsyncJob getJob(JobID jobID, boolean andRemove) {
        AsyncJob asyncJob = null;
        boolean foundJob = false;
        if (andRemove) {
            asyncJob = (AsyncJob)this.asyncJobs.get(jobID);
            foundJob = this.asyncJobs.remove(jobID, this.asyncJobs.get(jobID));
        } else {
            asyncJob = (AsyncJob)this.asyncJobs.get(jobID);
            foundJob = asyncJob != null;
        }
        return foundJob ? asyncJob : null;
    }

    static /* synthetic */ AsyncJob getJob$default(AsyncJobManager asyncJobManager, JobID jobID, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return asyncJobManager.getJob(jobID, bl);
    }
}

