/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.steamclient;

import in.dragonbra.javasteam.base.ClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.handlers.ClientMsgHandler;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserver;
import in.dragonbra.javasteam.steam.CMClient;
import in.dragonbra.javasteam.steam.handlers.steamapps.SteamApps;
import in.dragonbra.javasteam.steam.handlers.steamcloud.SteamCloud;
import in.dragonbra.javasteam.steam.handlers.steamfriends.SteamFriends;
import in.dragonbra.javasteam.steam.handlers.steamgamecoordinator.SteamGameCoordinator;
import in.dragonbra.javasteam.steam.handlers.steamgameserver.SteamGameServer;
import in.dragonbra.javasteam.steam.handlers.steammasterserver.SteamMasterServer;
import in.dragonbra.javasteam.steam.handlers.steamnetworking.SteamNetworking;
import in.dragonbra.javasteam.steam.handlers.steamnotifications.SteamNotifications;
import in.dragonbra.javasteam.steam.handlers.steamscreenshots.SteamScreenshots;
import in.dragonbra.javasteam.steam.handlers.steamtrading.SteamTrading;
import in.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages;
import in.dragonbra.javasteam.steam.handlers.steamuser.SteamUser;
import in.dragonbra.javasteam.steam.handlers.steamuserstats.SteamUserStats;
import in.dragonbra.javasteam.steam.handlers.steamworkshop.SteamWorkshop;
import in.dragonbra.javasteam.steam.steamclient.AsyncJobManager;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.steam.steamclient.callbackmgr.ICallbackMsg;
import in.dragonbra.javasteam.steam.steamclient.callbacks.CMListCallback;
import in.dragonbra.javasteam.steam.steamclient.callbacks.ConnectedCallback;
import in.dragonbra.javasteam.steam.steamclient.callbacks.DisconnectedCallback;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfiguration;
import in.dragonbra.javasteam.types.AsyncJob;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.util.compat.Consumer;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;

public class SteamClient
extends CMClient {
    private static final Logger logger = LogManager.getLogger(SteamClient.class);
    private final Map<Class<? extends ClientMsgHandler>, ClientMsgHandler> handlers = new HashMap<Class<? extends ClientMsgHandler>, ClientMsgHandler>();
    private final AsyncJobManager jobManager;
    private final AtomicLong currentJobId = new AtomicLong(0L);
    private final Date processStartTime;
    private final Object callbackLock = new Object();
    private final Queue<ICallbackMsg> callbackQueue = new LinkedList<ICallbackMsg>();
    private final Map<EMsg, Consumer<IPacketMsg>> dispatchMap = new HashMap<EMsg, Consumer<IPacketMsg>>();

    public SteamClient() {
        this(SteamConfiguration.createDefault());
    }

    public SteamClient(SteamConfiguration configuration) {
        super(configuration);
        this.addHandler(new SteamFriends());
        this.addHandler(new SteamUser());
        this.addHandler(new SteamApps());
        this.addHandler(new SteamGameCoordinator());
        this.addHandler(new SteamGameServer());
        this.addHandler(new SteamMasterServer());
        this.addHandler(new SteamCloud());
        this.addHandler(new SteamWorkshop());
        this.addHandler(new SteamTrading());
        this.addHandler(new SteamUnifiedMessages());
        this.addHandler(new SteamScreenshots());
        this.addHandler(new SteamNetworking());
        this.addHandler(new SteamNotifications());
        this.addHandler(new SteamUserStats());
        this.processStartTime = new Date();
        this.dispatchMap.put(EMsg.ClientCMList, this::handleCMList);
        this.dispatchMap.put(EMsg.JobHeartbeat, this::handleJobHeartbeat);
        this.dispatchMap.put(EMsg.DestJobFailed, this::handleJobFailed);
        this.jobManager = new AsyncJobManager();
    }

    public void addHandler(ClientMsgHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler is null");
        }
        if (this.handlers.containsKey(handler.getClass())) {
            throw new IllegalArgumentException("A handler of type " + handler.getClass() + " is already registered.");
        }
        handler.setup(this);
        this.handlers.put(handler.getClass(), handler);
    }

    public void removeHandler(Class<? extends ClientMsgHandler> handler) {
        this.handlers.remove(handler);
    }

    public void removeHandler(ClientMsgHandler handler) {
        this.removeHandler(handler.getClass());
    }

    public <T extends ClientMsgHandler> T getHandler(Class<T> type) {
        return (T)this.handlers.get(type);
    }

    public ICallbackMsg getCallback() {
        return this.getCallback(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICallbackMsg getCallback(boolean freeLast) {
        Object object = this.callbackLock;
        synchronized (object) {
            if (!this.callbackQueue.isEmpty()) {
                return freeLast ? this.callbackQueue.poll() : this.callbackQueue.peek();
            }
        }
        return null;
    }

    public ICallbackMsg waitForCallback() {
        return this.waitForCallback(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICallbackMsg waitForCallback(long timeout) {
        Object object = this.callbackLock;
        synchronized (object) {
            if (this.callbackQueue.isEmpty()) {
                try {
                    this.callbackLock.wait(timeout);
                }
                catch (InterruptedException e) {
                    logger.debug(e);
                }
                if (this.callbackQueue.isEmpty()) {
                    return null;
                }
            }
            return this.callbackQueue.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICallbackMsg waitForCallback(boolean freeLast) {
        Object object = this.callbackLock;
        synchronized (object) {
            if (this.callbackQueue.isEmpty()) {
                try {
                    this.callbackLock.wait();
                }
                catch (InterruptedException e) {
                    logger.debug(e);
                }
                if (this.callbackQueue.isEmpty()) {
                    return null;
                }
            }
            return freeLast ? this.callbackQueue.poll() : this.callbackQueue.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICallbackMsg waitForCallback(boolean freeLast, long timeout) {
        Object object = this.callbackLock;
        synchronized (object) {
            if (this.callbackQueue.isEmpty()) {
                try {
                    this.callbackLock.wait(timeout);
                }
                catch (InterruptedException e) {
                    logger.debug(e);
                }
            }
            return freeLast ? this.callbackQueue.poll() : this.callbackQueue.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICallbackMsg> getAllCallbacks(boolean freeLast, long timeout) {
        ArrayList<ICallbackMsg> callbacks;
        Object object = this.callbackLock;
        synchronized (object) {
            if (this.callbackQueue.isEmpty()) {
                try {
                    this.callbackLock.wait(timeout);
                }
                catch (InterruptedException e) {
                    logger.debug(e);
                }
                if (this.callbackQueue.isEmpty()) {
                    return new ArrayList<ICallbackMsg>();
                }
            }
            callbacks = new ArrayList<ICallbackMsg>(this.callbackQueue);
            if (freeLast) {
                this.callbackQueue.clear();
            }
        }
        return callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeLastCallback() {
        Object object = this.callbackLock;
        synchronized (object) {
            if (this.callbackQueue.isEmpty()) {
                return;
            }
            this.callbackQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCallback(CallbackMsg msg) {
        if (msg == null) {
            return;
        }
        Object object = this.callbackLock;
        synchronized (object) {
            this.callbackQueue.offer(msg);
            this.callbackLock.notify();
        }
        this.jobManager.tryCompleteJob(msg.getJobID(), msg);
    }

    public JobID getNextJobID() {
        long sequence = this.currentJobId.incrementAndGet();
        JobID jobID = new JobID();
        jobID.setBoxID(0L);
        jobID.setProcessID(0L);
        jobID.setSequentialCount(sequence);
        jobID.setStartTime(this.processStartTime);
        return jobID;
    }

    public void startJob(AsyncJob job) {
        this.jobManager.startJob(job);
    }

    public AsyncJobManager getJobManager() {
        return this.jobManager;
    }

    @Override
    protected boolean onClientMsgReceived(IPacketMsg packetMsg) {
        if (!super.onClientMsgReceived(packetMsg)) {
            return false;
        }
        Consumer<IPacketMsg> dispatcher = this.dispatchMap.get((Object)packetMsg.getMsgType());
        if (dispatcher != null) {
            dispatcher.accept(packetMsg);
        }
        for (Map.Entry<Class<? extends ClientMsgHandler>, ClientMsgHandler> entry : this.handlers.entrySet()) {
            try {
                entry.getValue().handleMsg(packetMsg);
            }
            catch (Exception e) {
                logger.debug("Unhandled exception from " + entry.getKey().getName() + " handlers", e);
                this.disconnect();
                return false;
            }
        }
        return true;
    }

    @Override
    protected void onClientConnected() {
        super.onClientConnected();
        this.jobManager.setTimeoutsEnabled(true);
        this.postCallback(new ConnectedCallback());
    }

    @Override
    protected void onClientDisconnected(boolean userInitiated) {
        super.onClientDisconnected(userInitiated);
        this.jobManager.cancelPendingJobs();
        this.jobManager.setTimeoutsEnabled(false);
        this.postCallback(new DisconnectedCallback(userInitiated));
    }

    private void handleCMList(IPacketMsg packetMsg) {
        ClientMsgProtobuf cmMsg = new ClientMsgProtobuf(SteammessagesClientserver.CMsgClientCMList.class, packetMsg);
        this.postCallback(new CMListCallback((SteammessagesClientserver.CMsgClientCMList.Builder)cmMsg.getBody()));
    }

    private void handleJobHeartbeat(IPacketMsg packetMsg) {
        JobID jobID = new JobID(packetMsg.getTargetJobID());
        this.jobManager.heartbeatJob(jobID);
    }

    private void handleJobFailed(IPacketMsg packetMsg) {
        JobID jobID = new JobID(packetMsg.getTargetJobID());
        this.jobManager.failJob(jobID);
    }
}

