/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.types;

import in.dragonbra.javasteam.types.BitVector64;
import in.dragonbra.javasteam.util.Utils;
import in.dragonbra.javasteam.util.compat.ObjectsCompat;

public class GameID {
    private final BitVector64 gameId;

    public GameID() {
        this(0);
    }

    public GameID(long id) {
        this.gameId = new BitVector64(id);
    }

    public GameID(int nAppId) {
        this((long)nAppId);
    }

    public GameID(int nAppId, String modPath) {
        this(0);
        this.setAppID(nAppId);
        this.setAppType(GameType.GAME_MOD);
        this.setModID(Utils.crc32(modPath));
    }

    public GameID(String exePath, String appName) {
        this(0);
        StringBuilder builder = new StringBuilder();
        if (exePath != null) {
            builder.append(exePath);
        }
        if (appName != null) {
            builder.append(appName);
        }
        this.setAppID(0);
        this.setAppType(GameType.SHORTCUT);
        this.setModID(Utils.crc32(builder.toString()));
    }

    public void set(long gameId) {
        this.gameId.setData(gameId);
    }

    public long toUInt64() {
        return this.gameId.getData();
    }

    public void setAppID(int value) {
        this.gameId.setMask((short)0, 0xFFFFFFL, value);
    }

    public int getAppID() {
        return (int)this.gameId.getMask((short)0, 0xFFFFFFL);
    }

    public void setAppType(GameType value) {
        this.gameId.setMask((short)24, 255L, value.code());
    }

    public GameType getAppType() {
        return GameType.from((int)this.gameId.getMask((short)24, 255L));
    }

    public void setModID(long value) {
        this.gameId.setMask((short)32, 0xFFFFFFFFL, value);
        this.gameId.setMask((short)63, 255L, 1L);
    }

    public long getModID() {
        return this.gameId.getMask((short)32, 0xFFFFFFFFL);
    }

    public boolean isMod() {
        return this.getAppType() == GameType.GAME_MOD;
    }

    public boolean isShortcut() {
        return this.getAppType() == GameType.SHORTCUT;
    }

    public boolean isP2PFile() {
        return this.getAppType() == GameType.P2P;
    }

    public boolean isSteamApp() {
        return this.getAppType() == GameType.APP;
    }

    public void setFromUInt64(long longSteamId) {
        this.gameId.setData(longSteamId);
    }

    public long convertToUInt64() {
        return this.gameId.getData();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameID)) {
            return false;
        }
        return ObjectsCompat.equals(this.gameId.getData(), ((GameID)obj).gameId.getData());
    }

    public int hashCode() {
        return this.gameId.hashCode();
    }

    public String toString() {
        return String.valueOf(this.toUInt64());
    }

    public static enum GameType {
        APP(0),
        GAME_MOD(1),
        SHORTCUT(2),
        P2P(3);

        private final int code;

        private GameType(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public static GameType from(int code) {
            for (GameType e : GameType.values()) {
                if (e.code != code) continue;
                return e;
            }
            return null;
        }
    }
}

