/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util.stream;

import in.dragonbra.javasteam.util.stream.BinaryWriter;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class BinaryReader
extends FilterInputStream {
    private final byte[] readBuffer = new byte[8];
    private int position = 0;

    public BinaryReader(InputStream in) {
        super(in);
    }

    public int readInt() throws IOException {
        int ch1 = this.in.read();
        int ch2 = this.in.read();
        int ch3 = this.in.read();
        int ch4 = this.in.read();
        this.position += 4;
        if ((ch1 | ch2 | ch3 | ch4) < 0) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
    }

    public byte[] readBytes(int len) throws IOException {
        if (len < 0) {
            throw new IOException("negative length");
        }
        byte[] bytes = new byte[len];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = this.readByte();
        }
        return bytes;
    }

    public byte readByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        ++this.position;
        return (byte)ch;
    }

    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.position += 2;
        return (short)((ch2 << 8) + ch1);
    }

    public long readLong() throws IOException {
        this.in.read(this.readBuffer, 0, 8);
        this.position += 8;
        return ((long)this.readBuffer[7] << 56) + ((long)(this.readBuffer[6] & 0xFF) << 48) + ((long)(this.readBuffer[5] & 0xFF) << 40) + ((long)(this.readBuffer[4] & 0xFF) << 32) + ((long)(this.readBuffer[3] & 0xFF) << 24) + (long)((this.readBuffer[2] & 0xFF) << 16) + (long)((this.readBuffer[1] & 0xFF) << 8) + (long)(this.readBuffer[0] & 0xFF);
    }

    public char readChar() throws IOException {
        int ch1 = this.in.read();
        if (ch1 < 0) {
            throw new EOFException();
        }
        ++this.position;
        return (char)ch1;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public boolean readBoolean() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        ++this.position;
        return ch != 0;
    }

    public String readNullTermString() throws IOException {
        return this.readNullTermString(Charset.defaultCharset());
    }

    public String readNullTermString(Charset charset) throws IOException {
        char ch;
        if (charset == null) {
            throw new IOException("charset is null");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(0);
        BinaryWriter bw = new BinaryWriter(buffer);
        while ((ch = this.readChar()) != '\u0000') {
            bw.writeChar(ch);
        }
        byte[] bytes = buffer.toByteArray();
        this.position += bytes.length;
        return new String(bytes, charset);
    }

    public int getPosition() {
        return this.position;
    }
}

