package `in`.dragonbra.javasteam.rpc.interfaces

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_AccessToken_GenerateForApp_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaQR_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_GetAuthSessionInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_GetAuthSessionsForAccount_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_MigrateMobileSession_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_PollAuthSessionStatus_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_RefreshToken_Enumerate_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_RefreshToken_Revoke_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_Token_Revoke_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithMobileConfirmation_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Request
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public interface IAuthentication {
  /**
   * @param request The request.
   * @see [CAuthentication_GetPasswordRSAPublicKey_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Response]
   */
  public fun getPasswordRSAPublicKey(request: CAuthentication_GetPasswordRSAPublicKey_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CAuthentication_BeginAuthSessionViaQR_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaQR_Response]
   */
  public fun beginAuthSessionViaQR(request: CAuthentication_BeginAuthSessionViaQR_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CAuthentication_BeginAuthSessionViaCredentials_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Response]
   */
  public
      fun beginAuthSessionViaCredentials(request: CAuthentication_BeginAuthSessionViaCredentials_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CAuthentication_PollAuthSessionStatus_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_PollAuthSessionStatus_Response]
   */
  public fun pollAuthSessionStatus(request: CAuthentication_PollAuthSessionStatus_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CAuthentication_GetAuthSessionInfo_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_GetAuthSessionInfo_Response]
   */
  public fun getAuthSessionInfo(request: CAuthentication_GetAuthSessionInfo_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CAuthentication_UpdateAuthSessionWithMobileConfirmation_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithMobileConfirmation_Response]
   */
  public
      fun updateAuthSessionWithMobileConfirmation(request: CAuthentication_UpdateAuthSessionWithMobileConfirmation_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CAuthentication_UpdateAuthSessionWithSteamGuardCode_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Response]
   */
  public
      fun updateAuthSessionWithSteamGuardCode(request: CAuthentication_UpdateAuthSessionWithSteamGuardCode_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CAuthentication_AccessToken_GenerateForApp_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_AccessToken_GenerateForApp_Response]
   */
  public fun generateAccessTokenForApp(request: CAuthentication_AccessToken_GenerateForApp_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CAuthentication_RefreshToken_Enumerate_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_RefreshToken_Enumerate_Response]
   */
  public fun enumerateTokens(request: CAuthentication_RefreshToken_Enumerate_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CAuthentication_GetAuthSessionsForAccount_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_GetAuthSessionsForAccount_Response]
   */
  public fun getAuthSessionsForAccount(request: CAuthentication_GetAuthSessionsForAccount_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CAuthentication_MigrateMobileSession_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_MigrateMobileSession_Response]
   */
  public fun migrateMobileSession(request: CAuthentication_MigrateMobileSession_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CAuthentication_Token_Revoke_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_Token_Revoke_Response]
   */
  public fun revokeToken(request: CAuthentication_Token_Revoke_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CAuthentication_RefreshToken_Revoke_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_RefreshToken_Revoke_Response]
   */
  public fun revokeRefreshToken(request: CAuthentication_RefreshToken_Revoke_Request):
      AsyncJobSingle<ServiceMethodResponse>
}
