package `in`.dragonbra.javasteam.rpc.interfaces

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_AckChatMessage_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_AddRoleToUser_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateChatRoom_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateInviteLink_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateRole_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteChatMessages_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteChatRoom_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteInviteLink_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteRoleFromUser_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteRole_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_EndMiniGameForChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetBanList_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetChatRoomGroupState_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetChatRoomGroupSummary_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteLinkInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteLinksForGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteList_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetMessageHistory_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetMessageReactionReactors_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetMyChatRoomGroups_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetRoleActions_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetRolesForUser_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetRoles_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_InviteFriendToChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_JoinChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_JoinMiniGameForChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_JoinVoiceChat_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_KickUser_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_LeaveChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_LeaveVoiceChat_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_MuteUser_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RenameChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RenameChatRoom_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RenameRole_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_ReorderChatRoom_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_ReorderRole_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_ReplaceRoleActions_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RevokeInvite_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SaveChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SearchMembers_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SendChatMessage_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetAppChatRoomGroupForceActive_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetAppChatRoomGroupStopForceActive_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetChatRoomGroupAvatar_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetChatRoomGroupTagline_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetChatRoomGroupWatchingBroadcast_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetSessionActiveChatRoomGroups_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetUserBanState_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetUserChatGroupPreferences_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_UpdateMemberListView_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_UpdateMessageReaction_Request
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public interface IChatRoom {
  /**
   * @param request The request.
   * @see [CChatRoom_CreateChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateChatRoomGroup_Response]
   */
  public fun createChatRoomGroup(request: CChatRoom_CreateChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_SaveChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SaveChatRoomGroup_Response]
   */
  public fun saveChatRoomGroup(request: CChatRoom_SaveChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_RenameChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RenameChatRoomGroup_Response]
   */
  public fun renameChatRoomGroup(request: CChatRoom_RenameChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_SetChatRoomGroupTagline_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetChatRoomGroupTagline_Response]
   */
  public fun setChatRoomGroupTagline(request: CChatRoom_SetChatRoomGroupTagline_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_SetChatRoomGroupAvatar_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetChatRoomGroupAvatar_Response]
   */
  public fun setChatRoomGroupAvatar(request: CChatRoom_SetChatRoomGroupAvatar_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_SetChatRoomGroupWatchingBroadcast_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetChatRoomGroupWatchingBroadcast_Response]
   */
  public
      fun setChatRoomGroupWatchingBroadcast(request: CChatRoom_SetChatRoomGroupWatchingBroadcast_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_JoinMiniGameForChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_JoinMiniGameForChatRoomGroup_Response]
   */
  public fun joinMiniGameForChatRoomGroup(request: CChatRoom_JoinMiniGameForChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_EndMiniGameForChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_EndMiniGameForChatRoomGroup_Response]
   */
  public fun endMiniGameForChatRoomGroup(request: CChatRoom_EndMiniGameForChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_MuteUser_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_MuteUser_Response]
   */
  public fun muteUserInGroup(request: CChatRoom_MuteUser_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_KickUser_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_KickUser_Response]
   */
  public fun kickUserFromGroup(request: CChatRoom_KickUser_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_SetUserBanState_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetUserBanState_Response]
   */
  public fun setUserBanState(request: CChatRoom_SetUserBanState_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_RevokeInvite_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RevokeInvite_Response]
   */
  public fun revokeInviteToGroup(request: CChatRoom_RevokeInvite_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_CreateRole_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateRole_Response]
   */
  public fun createRole(request: CChatRoom_CreateRole_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_GetRoles_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetRoles_Response]
   */
  public fun getRoles(request: CChatRoom_GetRoles_Request): AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_RenameRole_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RenameRole_Response]
   */
  public fun renameRole(request: CChatRoom_RenameRole_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_ReorderRole_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_ReorderRole_Response]
   */
  public fun reorderRole(request: CChatRoom_ReorderRole_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_DeleteRole_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteRole_Response]
   */
  public fun deleteRole(request: CChatRoom_DeleteRole_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_GetRoleActions_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetRoleActions_Response]
   */
  public fun getRoleActions(request: CChatRoom_GetRoleActions_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_ReplaceRoleActions_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_ReplaceRoleActions_Response]
   */
  public fun replaceRoleActions(request: CChatRoom_ReplaceRoleActions_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_AddRoleToUser_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_AddRoleToUser_Response]
   */
  public fun addRoleToUser(request: CChatRoom_AddRoleToUser_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_GetRolesForUser_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetRolesForUser_Response]
   */
  public fun getRolesForUser(request: CChatRoom_GetRolesForUser_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_DeleteRoleFromUser_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteRoleFromUser_Response]
   */
  public fun deleteRoleFromUser(request: CChatRoom_DeleteRoleFromUser_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_JoinChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_JoinChatRoomGroup_Response]
   */
  public fun joinChatRoomGroup(request: CChatRoom_JoinChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_InviteFriendToChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_InviteFriendToChatRoomGroup_Response]
   */
  public fun inviteFriendToChatRoomGroup(request: CChatRoom_InviteFriendToChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_LeaveChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_LeaveChatRoomGroup_Response]
   */
  public fun leaveChatRoomGroup(request: CChatRoom_LeaveChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_CreateChatRoom_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateChatRoom_Response]
   */
  public fun createChatRoom(request: CChatRoom_CreateChatRoom_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_DeleteChatRoom_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteChatRoom_Response]
   */
  public fun deleteChatRoom(request: CChatRoom_DeleteChatRoom_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_RenameChatRoom_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RenameChatRoom_Response]
   */
  public fun renameChatRoom(request: CChatRoom_RenameChatRoom_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_ReorderChatRoom_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_ReorderChatRoom_Response]
   */
  public fun reorderChatRoom(request: CChatRoom_ReorderChatRoom_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_SendChatMessage_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SendChatMessage_Response]
   */
  public fun sendChatMessage(request: CChatRoom_SendChatMessage_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_JoinVoiceChat_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_JoinVoiceChat_Response]
   */
  public fun joinVoiceChat(request: CChatRoom_JoinVoiceChat_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_LeaveVoiceChat_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_LeaveVoiceChat_Response]
   */
  public fun leaveVoiceChat(request: CChatRoom_LeaveVoiceChat_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_GetMessageHistory_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetMessageHistory_Response]
   */
  public fun getMessageHistory(request: CChatRoom_GetMessageHistory_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_GetMyChatRoomGroups_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetMyChatRoomGroups_Response]
   */
  public fun getMyChatRoomGroups(request: CChatRoom_GetMyChatRoomGroups_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_GetChatRoomGroupState_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetChatRoomGroupState_Response]
   */
  public fun getChatRoomGroupState(request: CChatRoom_GetChatRoomGroupState_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_GetChatRoomGroupSummary_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetChatRoomGroupSummary_Response]
   */
  public fun getChatRoomGroupSummary(request: CChatRoom_GetChatRoomGroupSummary_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_SetAppChatRoomGroupForceActive_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetAppChatRoomGroupForceActive_Response]
   */
  public
      fun setAppChatRoomGroupForceActive(request: CChatRoom_SetAppChatRoomGroupForceActive_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * No return value.
   */
  public
      fun setAppChatRoomGroupStopForceActive(request: CChatRoom_SetAppChatRoomGroupStopForceActive_Notification)

  /**
   * No return value.
   */
  public fun ackChatMessage(request: CChatRoom_AckChatMessage_Notification)

  /**
   * @param request The request.
   * @see [CChatRoom_CreateInviteLink_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateInviteLink_Response]
   */
  public fun createInviteLink(request: CChatRoom_CreateInviteLink_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_GetInviteLinkInfo_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteLinkInfo_Response]
   */
  public fun getInviteLinkInfo(request: CChatRoom_GetInviteLinkInfo_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_GetInviteInfo_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteInfo_Response]
   */
  public fun getInviteInfo(request: CChatRoom_GetInviteInfo_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_GetInviteLinksForGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteLinksForGroup_Response]
   */
  public fun getInviteLinksForGroup(request: CChatRoom_GetInviteLinksForGroup_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_GetBanList_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetBanList_Response]
   */
  public fun getBanList(request: CChatRoom_GetBanList_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_GetInviteList_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteList_Response]
   */
  public fun getInviteList(request: CChatRoom_GetInviteList_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_DeleteInviteLink_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteInviteLink_Response]
   */
  public fun deleteInviteLink(request: CChatRoom_DeleteInviteLink_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_SetSessionActiveChatRoomGroups_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetSessionActiveChatRoomGroups_Response]
   */
  public
      fun setSessionActiveChatRoomGroups(request: CChatRoom_SetSessionActiveChatRoomGroups_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_SetUserChatGroupPreferences_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetUserChatGroupPreferences_Response]
   */
  public fun setUserChatGroupPreferences(request: CChatRoom_SetUserChatGroupPreferences_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_DeleteChatMessages_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteChatMessages_Response]
   */
  public fun deleteChatMessages(request: CChatRoom_DeleteChatMessages_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * No return value.
   */
  public fun updateMemberListView(request: CChatRoom_UpdateMemberListView_Notification)

  /**
   * @param request The request.
   * @see [CChatRoom_SearchMembers_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SearchMembers_Response]
   */
  public fun searchMembers(request: CChatRoom_SearchMembers_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_UpdateMessageReaction_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_UpdateMessageReaction_Response]
   */
  public fun updateMessageReaction(request: CChatRoom_UpdateMessageReaction_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CChatRoom_GetMessageReactionReactors_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetMessageReactionReactors_Response]
   */
  public fun getMessageReactionReactors(request: CChatRoom_GetMessageReactionReactors_Request):
      AsyncJobSingle<ServiceMethodResponse>
}
