package `in`.dragonbra.javasteam.rpc.interfaces

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetCDNAuthToken_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetClientUpdateHosts_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetDepotPatchInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetManifestRequestCode_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetPeerContentInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetServersForSteamPipe_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_RequestPeerContentServer_Request
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public interface IContentServerDirectory {
  /**
   * @param request The request.
   * @see [CContentServerDirectory_GetServersForSteamPipe_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetServersForSteamPipe_Response]
   */
  public
      fun getServersForSteamPipe(request: CContentServerDirectory_GetServersForSteamPipe_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CContentServerDirectory_GetDepotPatchInfo_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetDepotPatchInfo_Response]
   */
  public fun getDepotPatchInfo(request: CContentServerDirectory_GetDepotPatchInfo_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CContentServerDirectory_GetClientUpdateHosts_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetClientUpdateHosts_Response]
   */
  public fun getClientUpdateHosts(request: CContentServerDirectory_GetClientUpdateHosts_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CContentServerDirectory_GetManifestRequestCode_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetManifestRequestCode_Response]
   */
  public
      fun getManifestRequestCode(request: CContentServerDirectory_GetManifestRequestCode_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CContentServerDirectory_GetCDNAuthToken_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetCDNAuthToken_Response]
   */
  public fun getCDNAuthToken(request: CContentServerDirectory_GetCDNAuthToken_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CContentServerDirectory_RequestPeerContentServer_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_RequestPeerContentServer_Response]
   */
  public
      fun requestPeerContentServer(request: CContentServerDirectory_RequestPeerContentServer_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CContentServerDirectory_GetPeerContentInfo_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetPeerContentInfo_Response]
   */
  public fun getPeerContentInfo(request: CContentServerDirectory_GetPeerContentInfo_Request):
      AsyncJobSingle<ServiceMethodResponse>
}
