package `in`.dragonbra.javasteam.rpc.interfaces

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_AckMessage_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_GetRecentMessages_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_IsInFriendsUIBeta_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_SendMessage_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_UpdateMessageReaction_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendsMessages_GetActiveMessageSessions_Request
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public interface IFriendMessages {
  /**
   * @param request The request.
   * @see [CFriendMessages_GetRecentMessages_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_GetRecentMessages_Response]
   */
  public fun getRecentMessages(request: CFriendMessages_GetRecentMessages_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CFriendsMessages_GetActiveMessageSessions_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendsMessages_GetActiveMessageSessions_Response]
   */
  public fun getActiveMessageSessions(request: CFriendsMessages_GetActiveMessageSessions_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CFriendMessages_SendMessage_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_SendMessage_Response]
   */
  public fun sendMessage(request: CFriendMessages_SendMessage_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * No return value.
   */
  public fun ackMessage(request: CFriendMessages_AckMessage_Notification)

  /**
   * @param request The request.
   * @see [CFriendMessages_IsInFriendsUIBeta_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_IsInFriendsUIBeta_Response]
   */
  public fun isInFriendsUIBeta(request: CFriendMessages_IsInFriendsUIBeta_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CFriendMessages_UpdateMessageReaction_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_UpdateMessageReaction_Response]
   */
  public fun updateMessageReaction(request: CFriendMessages_UpdateMessageReaction_Request):
      AsyncJobSingle<ServiceMethodResponse>
}
