package `in`.dragonbra.javasteam.rpc.interfaces

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_AddItem_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_CombineItemStacks_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_ConsumeItem_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_ConsumePlaytime_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_DevSetNextDrop_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_ExchangeItem_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_GetEligiblePromoItemDefIDs_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_GetInventory_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_GetItemDefMeta_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_GetUserPurchaseInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_InspectItem_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_ModifyItems_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_PurchaseFinalize_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_PurchaseInit_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_SplitItemStack_Request
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public interface IInventory {
  /**
   * @param request The request.
   * @see [CInventory_GetInventory_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  public fun getInventory(request: CInventory_GetInventory_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CInventory_ExchangeItem_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  public fun exchangeItem(request: CInventory_ExchangeItem_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CInventory_GetEligiblePromoItemDefIDs_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_GetEligiblePromoItemDefIDs_Response]
   */
  public fun getEligiblePromoItemDefIDs(request: CInventory_GetEligiblePromoItemDefIDs_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CInventory_AddItem_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  public fun addPromoItem(request: CInventory_AddItem_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CInventory_ModifyItems_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  public fun safeModifyItems(request: CInventory_ModifyItems_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CInventory_ConsumePlaytime_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  public fun consumePlaytime(request: CInventory_ConsumePlaytime_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CInventory_ConsumeItem_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  public fun consumeItem(request: CInventory_ConsumeItem_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CInventory_AddItem_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  public fun devGenerateItem(request: CInventory_AddItem_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CInventory_DevSetNextDrop_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  public fun devSetNextDrop(request: CInventory_DevSetNextDrop_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CInventory_SplitItemStack_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  public fun splitItemStack(request: CInventory_SplitItemStack_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CInventory_CombineItemStacks_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  public fun combineItemStacks(request: CInventory_CombineItemStacks_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CInventory_GetItemDefMeta_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_GetItemDefMeta_Response]
   */
  public fun getItemDefMeta(request: CInventory_GetItemDefMeta_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CInventory_GetUserPurchaseInfo_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_GetUserPurchaseInfo_Response]
   */
  public fun getUserPurchaseInfo(request: CInventory_GetUserPurchaseInfo_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CInventory_PurchaseInit_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_PurchaseInit_Response]
   */
  public fun purchaseInit(request: CInventory_PurchaseInit_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CInventory_PurchaseFinalize_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  public fun purchaseFinalize(request: CInventory_PurchaseFinalize_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CInventory_InspectItem_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  public fun inspectItem(request: CInventory_InspectItem_Request):
      AsyncJobSingle<ServiceMethodResponse>
}
