package `in`.dragonbra.javasteam.rpc.interfaces

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ApproveFeatureAccess_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ApprovePlaytime_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_DisableParentalSettings_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_DisableWithRecoveryCode_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_EnableParentalSettings_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_GetParentalSettings_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_GetRequests_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_GetSignedParentalSettings_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_LockClient_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ReportPlaytimeAndNotify_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_RequestFeatureAccess_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_RequestPlaytime_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_RequestRecoveryCode_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_SetParentalSettings_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ValidatePassword_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ValidateToken_Request
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public interface IParental {
  /**
   * @param request The request.
   * @see [CParental_EnableParentalSettings_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_EnableParentalSettings_Response]
   */
  public fun enableParentalSettings(request: CParental_EnableParentalSettings_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CParental_DisableParentalSettings_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_DisableParentalSettings_Response]
   */
  public fun disableParentalSettings(request: CParental_DisableParentalSettings_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CParental_GetParentalSettings_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_GetParentalSettings_Response]
   */
  public fun getParentalSettings(request: CParental_GetParentalSettings_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CParental_GetSignedParentalSettings_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_GetSignedParentalSettings_Response]
   */
  public fun getSignedParentalSettings(request: CParental_GetSignedParentalSettings_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CParental_SetParentalSettings_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_SetParentalSettings_Response]
   */
  public fun setParentalSettings(request: CParental_SetParentalSettings_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CParental_ValidateToken_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ValidateToken_Response]
   */
  public fun validateToken(request: CParental_ValidateToken_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CParental_ValidatePassword_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ValidatePassword_Response]
   */
  public fun validatePassword(request: CParental_ValidatePassword_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CParental_LockClient_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_LockClient_Response]
   */
  public fun lockClient(request: CParental_LockClient_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CParental_RequestRecoveryCode_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_RequestRecoveryCode_Response]
   */
  public fun requestRecoveryCode(request: CParental_RequestRecoveryCode_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CParental_DisableWithRecoveryCode_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_DisableWithRecoveryCode_Response]
   */
  public fun disableWithRecoveryCode(request: CParental_DisableWithRecoveryCode_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CParental_RequestFeatureAccess_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_RequestFeatureAccess_Response]
   */
  public fun requestFeatureAccess(request: CParental_RequestFeatureAccess_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CParental_ApproveFeatureAccess_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ApproveFeatureAccess_Response]
   */
  public fun approveFeatureAccess(request: CParental_ApproveFeatureAccess_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CParental_RequestPlaytime_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_RequestPlaytime_Response]
   */
  public fun requestPlaytime(request: CParental_RequestPlaytime_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CParental_ApprovePlaytime_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ApprovePlaytime_Response]
   */
  public fun approvePlaytime(request: CParental_ApprovePlaytime_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CParental_GetRequests_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_GetRequests_Response]
   */
  public fun getRequests(request: CParental_GetRequests_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CParental_ReportPlaytimeAndNotify_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ReportPlaytimeAndNotify_Response]
   */
  public fun reportPlaytimeAndNotify(request: CParental_ReportPlaytimeAndNotify_Request):
      AsyncJobSingle<ServiceMethodResponse>
}
