package `in`.dragonbra.javasteam.rpc.interfaces

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_AllocateRelayServer_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_AllocateSDR_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_CreateRemotePlayTogetherInvitation_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_DeleteRemotePlayTogetherInvitation_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_GetPairingInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_Online_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_ReplyPacket_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_SteamBroadcast_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_SteamToSteam_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemotePlayTogether_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemotePlay_SessionStarted_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemotePlay_SessionStopped_Notification
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public interface IRemoteClient {
  /**
   * @param request The request.
   * @see [CRemoteClient_GetPairingInfo_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_GetPairingInfo_Response]
   */
  public fun getPairingInfo(request: CRemoteClient_GetPairingInfo_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * No return value.
   */
  public fun notifyOnline(request: CRemoteClient_Online_Notification)

  /**
   * No return value.
   */
  public fun notifyReplyPacket(request: CRemoteClient_ReplyPacket_Notification)

  /**
   * @param request The request.
   * @see [CRemoteClient_AllocateRelayServer_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_AllocateRelayServer_Response]
   */
  public fun allocateRelayServer(request: CRemoteClient_AllocateRelayServer_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CRemoteClient_AllocateSDR_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_AllocateSDR_Response]
   */
  public fun allocateSDR(request: CRemoteClient_AllocateSDR_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * No return value.
   */
  public fun sendSteamBroadcastPacket(request: CRemoteClient_SteamBroadcast_Notification)

  /**
   * No return value.
   */
  public fun sendSteamToSteamPacket(request: CRemoteClient_SteamToSteam_Notification)

  /**
   * @param request The request.
   * @see [CRemotePlay_SessionStarted_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemotePlay_SessionStarted_Response]
   */
  public fun sendRemotePlaySessionStarted(request: CRemotePlay_SessionStarted_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * No return value.
   */
  public fun sendRemotePlaySessionStopped(request: CRemotePlay_SessionStopped_Notification)

  /**
   * No return value.
   */
  public fun sendRemotePlayTogetherPacket(request: CRemotePlayTogether_Notification)

  /**
   * @param request The request.
   * @see [CRemoteClient_CreateRemotePlayTogetherInvitation_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_CreateRemotePlayTogetherInvitation_Response]
   */
  public
      fun createRemotePlayTogetherInvitation(request: CRemoteClient_CreateRemotePlayTogetherInvitation_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CRemoteClient_DeleteRemotePlayTogetherInvitation_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_DeleteRemotePlayTogetherInvitation_Response]
   */
  public
      fun deleteRemotePlayTogetherInvitation(request: CRemoteClient_DeleteRemotePlayTogetherInvitation_Request):
      AsyncJobSingle<ServiceMethodResponse>
}
