package `in`.dragonbra.javasteam.rpc.interfaces

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_AddAuthenticator_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_FinalizeAddAuthenticator_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_RemoveAuthenticatorViaChallengeContinue_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_RemoveAuthenticatorViaChallengeStart_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_RemoveAuthenticator_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_SendEmail_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_Status_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_Time_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_UpdateTokenVersion_Request
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public interface ITwoFactor {
  /**
   * @param request The request.
   * @see [CTwoFactor_Time_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_Time_Response]
   */
  public fun queryTime(request: CTwoFactor_Time_Request): AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CTwoFactor_Status_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_Status_Response]
   */
  public fun queryStatus(request: CTwoFactor_Status_Request): AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CTwoFactor_AddAuthenticator_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_AddAuthenticator_Response]
   */
  public fun addAuthenticator(request: CTwoFactor_AddAuthenticator_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CTwoFactor_SendEmail_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_SendEmail_Response]
   */
  public fun sendEmail(request: CTwoFactor_SendEmail_Request): AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CTwoFactor_FinalizeAddAuthenticator_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_FinalizeAddAuthenticator_Response]
   */
  public fun finalizeAddAuthenticator(request: CTwoFactor_FinalizeAddAuthenticator_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CTwoFactor_UpdateTokenVersion_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_UpdateTokenVersion_Response]
   */
  public fun updateTokenVersion(request: CTwoFactor_UpdateTokenVersion_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CTwoFactor_RemoveAuthenticator_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_RemoveAuthenticator_Response]
   */
  public fun removeAuthenticator(request: CTwoFactor_RemoveAuthenticator_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CTwoFactor_RemoveAuthenticatorViaChallengeStart_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_RemoveAuthenticatorViaChallengeStart_Response]
   */
  public
      fun removeAuthenticatorViaChallengeStart(request: CTwoFactor_RemoveAuthenticatorViaChallengeStart_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CTwoFactor_RemoveAuthenticatorViaChallengeContinue_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesTwofactorSteamclient.CTwoFactor_RemoveAuthenticatorViaChallengeContinue_Response]
   */
  public
      fun removeAuthenticatorViaChallengeContinue(request: CTwoFactor_RemoveAuthenticatorViaChallengeContinue_Request):
      AsyncJobSingle<ServiceMethodResponse>
}
