package `in`.dragonbra.javasteam.rpc.interfaces

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_CancelLicenseForApp_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_CreateFriendInviteToken_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_GetAccountLinkStatus_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_GetAvailableValveDiscountPromotions_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_GetClientWalletDetails_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_GetFriendInviteTokens_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_GetUserCountry_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_RedeemFriendInviteToken_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_RegisterCompatTool_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_RevokeFriendInviteToken_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_ViewFriendInviteToken_Request
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public interface IUserAccount {
  /**
   * @param request The request.
   * @see [CUserAccount_GetAvailableValveDiscountPromotions_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_GetAvailableValveDiscountPromotions_Response]
   */
  public
      fun getAvailableValveDiscountPromotions(request: CUserAccount_GetAvailableValveDiscountPromotions_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CUserAccount_GetClientWalletDetails_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_GetWalletDetails_Response]
   */
  public fun getClientWalletDetails(request: CUserAccount_GetClientWalletDetails_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CUserAccount_GetAccountLinkStatus_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_GetAccountLinkStatus_Response]
   */
  public fun getAccountLinkStatus(request: CUserAccount_GetAccountLinkStatus_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CUserAccount_CancelLicenseForApp_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_CancelLicenseForApp_Response]
   */
  public fun cancelLicenseForApp(request: CUserAccount_CancelLicenseForApp_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CUserAccount_GetUserCountry_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_GetUserCountry_Response]
   */
  public fun getUserCountry(request: CUserAccount_GetUserCountry_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CUserAccount_CreateFriendInviteToken_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_CreateFriendInviteToken_Response]
   */
  public fun createFriendInviteToken(request: CUserAccount_CreateFriendInviteToken_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CUserAccount_GetFriendInviteTokens_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_GetFriendInviteTokens_Response]
   */
  public fun getFriendInviteTokens(request: CUserAccount_GetFriendInviteTokens_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CUserAccount_ViewFriendInviteToken_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_ViewFriendInviteToken_Response]
   */
  public fun viewFriendInviteToken(request: CUserAccount_ViewFriendInviteToken_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CUserAccount_RedeemFriendInviteToken_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_RedeemFriendInviteToken_Response]
   */
  public fun redeemFriendInviteToken(request: CUserAccount_RedeemFriendInviteToken_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CUserAccount_RevokeFriendInviteToken_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_RevokeFriendInviteToken_Response]
   */
  public fun revokeFriendInviteToken(request: CUserAccount_RevokeFriendInviteToken_Request):
      AsyncJobSingle<ServiceMethodResponse>

  /**
   * @param request The request.
   * @see [CUserAccount_RegisterCompatTool_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CUserAccount_RegisterCompatTool_Response]
   */
  public fun registerCompatTool(request: CUserAccount_RegisterCompatTool_Request):
      AsyncJobSingle<ServiceMethodResponse>
}
