package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_AccessToken_GenerateForApp_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaQR_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_GetAuthSessionInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_GetAuthSessionsForAccount_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_MigrateMobileSession_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_PollAuthSessionStatus_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_RefreshToken_Enumerate_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_RefreshToken_Revoke_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_Token_Revoke_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithMobileConfirmation_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Request
import `in`.dragonbra.javasteam.rpc.interfaces.IAuthentication
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class Authentication(
  steamUnifiedMessages: SteamUnifiedMessages,
) : UnifiedService(steamUnifiedMessages),
    IAuthentication {
  /**
   * @param request The request.
   * @see [CAuthentication_GetPasswordRSAPublicKey_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_GetPasswordRSAPublicKey_Response]
   */
  override fun getPasswordRSAPublicKey(request: CAuthentication_GetPasswordRSAPublicKey_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetPasswordRSAPublicKey")

  /**
   * @param request The request.
   * @see [CAuthentication_BeginAuthSessionViaQR_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaQR_Response]
   */
  override fun beginAuthSessionViaQR(request: CAuthentication_BeginAuthSessionViaQR_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "BeginAuthSessionViaQR")

  /**
   * @param request The request.
   * @see [CAuthentication_BeginAuthSessionViaCredentials_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_BeginAuthSessionViaCredentials_Response]
   */
  override
      fun beginAuthSessionViaCredentials(request: CAuthentication_BeginAuthSessionViaCredentials_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "BeginAuthSessionViaCredentials")

  /**
   * @param request The request.
   * @see [CAuthentication_PollAuthSessionStatus_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_PollAuthSessionStatus_Response]
   */
  override fun pollAuthSessionStatus(request: CAuthentication_PollAuthSessionStatus_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "PollAuthSessionStatus")

  /**
   * @param request The request.
   * @see [CAuthentication_GetAuthSessionInfo_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_GetAuthSessionInfo_Response]
   */
  override fun getAuthSessionInfo(request: CAuthentication_GetAuthSessionInfo_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetAuthSessionInfo")

  /**
   * @param request The request.
   * @see [CAuthentication_UpdateAuthSessionWithMobileConfirmation_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithMobileConfirmation_Response]
   */
  override
      fun updateAuthSessionWithMobileConfirmation(request: CAuthentication_UpdateAuthSessionWithMobileConfirmation_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request,
      "UpdateAuthSessionWithMobileConfirmation")

  /**
   * @param request The request.
   * @see [CAuthentication_UpdateAuthSessionWithSteamGuardCode_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_UpdateAuthSessionWithSteamGuardCode_Response]
   */
  override
      fun updateAuthSessionWithSteamGuardCode(request: CAuthentication_UpdateAuthSessionWithSteamGuardCode_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request,
      "UpdateAuthSessionWithSteamGuardCode")

  /**
   * @param request The request.
   * @see [CAuthentication_AccessToken_GenerateForApp_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_AccessToken_GenerateForApp_Response]
   */
  override
      fun generateAccessTokenForApp(request: CAuthentication_AccessToken_GenerateForApp_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GenerateAccessTokenForApp")

  /**
   * @param request The request.
   * @see [CAuthentication_RefreshToken_Enumerate_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_RefreshToken_Enumerate_Response]
   */
  override fun enumerateTokens(request: CAuthentication_RefreshToken_Enumerate_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "EnumerateTokens")

  /**
   * @param request The request.
   * @see [CAuthentication_GetAuthSessionsForAccount_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_GetAuthSessionsForAccount_Response]
   */
  override
      fun getAuthSessionsForAccount(request: CAuthentication_GetAuthSessionsForAccount_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetAuthSessionsForAccount")

  /**
   * @param request The request.
   * @see [CAuthentication_MigrateMobileSession_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_MigrateMobileSession_Response]
   */
  override fun migrateMobileSession(request: CAuthentication_MigrateMobileSession_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "MigrateMobileSession")

  /**
   * @param request The request.
   * @see [CAuthentication_Token_Revoke_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_Token_Revoke_Response]
   */
  override fun revokeToken(request: CAuthentication_Token_Revoke_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "RevokeToken")

  /**
   * @param request The request.
   * @see [CAuthentication_RefreshToken_Revoke_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthentication_RefreshToken_Revoke_Response]
   */
  override fun revokeRefreshToken(request: CAuthentication_RefreshToken_Revoke_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "RevokeRefreshToken")
}
