package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthenticationSupport_GetTokenHistory_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthenticationSupport_QueryRefreshTokenByID_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthenticationSupport_QueryRefreshTokensByAccount_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthenticationSupport_RevokeToken_Request
import `in`.dragonbra.javasteam.rpc.interfaces.IAuthenticationSupport
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class AuthenticationSupport(
  steamUnifiedMessages: SteamUnifiedMessages,
) : UnifiedService(steamUnifiedMessages),
    IAuthenticationSupport {
  /**
   * @param request The request.
   * @see [CAuthenticationSupport_QueryRefreshTokensByAccount_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthenticationSupport_QueryRefreshTokensByAccount_Response]
   */
  override
      fun queryRefreshTokensByAccount(request: CAuthenticationSupport_QueryRefreshTokensByAccount_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "QueryRefreshTokensByAccount")

  /**
   * @param request The request.
   * @see [CAuthenticationSupport_QueryRefreshTokenByID_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthenticationSupport_QueryRefreshTokenByID_Response]
   */
  override fun queryRefreshTokenByID(request: CAuthenticationSupport_QueryRefreshTokenByID_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "QueryRefreshTokenByID")

  /**
   * @param request The request.
   * @see [CAuthenticationSupport_RevokeToken_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthenticationSupport_RevokeToken_Response]
   */
  override fun revokeToken(request: CAuthenticationSupport_RevokeToken_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "RevokeToken")

  /**
   * @param request The request.
   * @see [CAuthenticationSupport_GetTokenHistory_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CAuthenticationSupport_GetTokenHistory_Response]
   */
  override fun getTokenHistory(request: CAuthenticationSupport_GetTokenHistory_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetTokenHistory")
}
