package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_AckChatMessage_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_AddRoleToUser_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateChatRoom_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateInviteLink_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateRole_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteChatMessages_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteChatRoom_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteInviteLink_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteRoleFromUser_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteRole_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_EndMiniGameForChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetBanList_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetChatRoomGroupState_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetChatRoomGroupSummary_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteLinkInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteLinksForGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteList_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetMessageHistory_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetMessageReactionReactors_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetMyChatRoomGroups_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetRoleActions_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetRolesForUser_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetRoles_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_InviteFriendToChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_JoinChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_JoinMiniGameForChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_JoinVoiceChat_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_KickUser_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_LeaveChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_LeaveVoiceChat_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_MuteUser_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RenameChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RenameChatRoom_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RenameRole_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_ReorderChatRoom_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_ReorderRole_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_ReplaceRoleActions_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RevokeInvite_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SaveChatRoomGroup_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SearchMembers_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SendChatMessage_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetAppChatRoomGroupForceActive_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetAppChatRoomGroupStopForceActive_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetChatRoomGroupAvatar_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetChatRoomGroupTagline_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetChatRoomGroupWatchingBroadcast_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetSessionActiveChatRoomGroups_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetUserBanState_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetUserChatGroupPreferences_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_UpdateMemberListView_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_UpdateMessageReaction_Request
import `in`.dragonbra.javasteam.rpc.interfaces.IChatRoom
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class ChatRoom(
  steamUnifiedMessages: SteamUnifiedMessages,
) : UnifiedService(steamUnifiedMessages),
    IChatRoom {
  /**
   * @param request The request.
   * @see [CChatRoom_CreateChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateChatRoomGroup_Response]
   */
  override fun createChatRoomGroup(request: CChatRoom_CreateChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "CreateChatRoomGroup")

  /**
   * @param request The request.
   * @see [CChatRoom_SaveChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SaveChatRoomGroup_Response]
   */
  override fun saveChatRoomGroup(request: CChatRoom_SaveChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "SaveChatRoomGroup")

  /**
   * @param request The request.
   * @see [CChatRoom_RenameChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RenameChatRoomGroup_Response]
   */
  override fun renameChatRoomGroup(request: CChatRoom_RenameChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "RenameChatRoomGroup")

  /**
   * @param request The request.
   * @see [CChatRoom_SetChatRoomGroupTagline_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetChatRoomGroupTagline_Response]
   */
  override fun setChatRoomGroupTagline(request: CChatRoom_SetChatRoomGroupTagline_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "SetChatRoomGroupTagline")

  /**
   * @param request The request.
   * @see [CChatRoom_SetChatRoomGroupAvatar_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetChatRoomGroupAvatar_Response]
   */
  override fun setChatRoomGroupAvatar(request: CChatRoom_SetChatRoomGroupAvatar_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "SetChatRoomGroupAvatar")

  /**
   * @param request The request.
   * @see [CChatRoom_SetChatRoomGroupWatchingBroadcast_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetChatRoomGroupWatchingBroadcast_Response]
   */
  override
      fun setChatRoomGroupWatchingBroadcast(request: CChatRoom_SetChatRoomGroupWatchingBroadcast_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request,
      "SetChatRoomGroupWatchingBroadcast")

  /**
   * @param request The request.
   * @see [CChatRoom_JoinMiniGameForChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_JoinMiniGameForChatRoomGroup_Response]
   */
  override
      fun joinMiniGameForChatRoomGroup(request: CChatRoom_JoinMiniGameForChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "JoinMiniGameForChatRoomGroup")

  /**
   * @param request The request.
   * @see [CChatRoom_EndMiniGameForChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_EndMiniGameForChatRoomGroup_Response]
   */
  override fun endMiniGameForChatRoomGroup(request: CChatRoom_EndMiniGameForChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "EndMiniGameForChatRoomGroup")

  /**
   * @param request The request.
   * @see [CChatRoom_MuteUser_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_MuteUser_Response]
   */
  override fun muteUserInGroup(request: CChatRoom_MuteUser_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "MuteUserInGroup")

  /**
   * @param request The request.
   * @see [CChatRoom_KickUser_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_KickUser_Response]
   */
  override fun kickUserFromGroup(request: CChatRoom_KickUser_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "KickUserFromGroup")

  /**
   * @param request The request.
   * @see [CChatRoom_SetUserBanState_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetUserBanState_Response]
   */
  override fun setUserBanState(request: CChatRoom_SetUserBanState_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "SetUserBanState")

  /**
   * @param request The request.
   * @see [CChatRoom_RevokeInvite_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RevokeInvite_Response]
   */
  override fun revokeInviteToGroup(request: CChatRoom_RevokeInvite_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "RevokeInviteToGroup")

  /**
   * @param request The request.
   * @see [CChatRoom_CreateRole_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateRole_Response]
   */
  override fun createRole(request: CChatRoom_CreateRole_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "CreateRole")

  /**
   * @param request The request.
   * @see [CChatRoom_GetRoles_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetRoles_Response]
   */
  override fun getRoles(request: CChatRoom_GetRoles_Request): AsyncJobSingle<ServiceMethodResponse>
      = sendMessage(request, "GetRoles")

  /**
   * @param request The request.
   * @see [CChatRoom_RenameRole_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RenameRole_Response]
   */
  override fun renameRole(request: CChatRoom_RenameRole_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "RenameRole")

  /**
   * @param request The request.
   * @see [CChatRoom_ReorderRole_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_ReorderRole_Response]
   */
  override fun reorderRole(request: CChatRoom_ReorderRole_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "ReorderRole")

  /**
   * @param request The request.
   * @see [CChatRoom_DeleteRole_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteRole_Response]
   */
  override fun deleteRole(request: CChatRoom_DeleteRole_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "DeleteRole")

  /**
   * @param request The request.
   * @see [CChatRoom_GetRoleActions_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetRoleActions_Response]
   */
  override fun getRoleActions(request: CChatRoom_GetRoleActions_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetRoleActions")

  /**
   * @param request The request.
   * @see [CChatRoom_ReplaceRoleActions_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_ReplaceRoleActions_Response]
   */
  override fun replaceRoleActions(request: CChatRoom_ReplaceRoleActions_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "ReplaceRoleActions")

  /**
   * @param request The request.
   * @see [CChatRoom_AddRoleToUser_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_AddRoleToUser_Response]
   */
  override fun addRoleToUser(request: CChatRoom_AddRoleToUser_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "AddRoleToUser")

  /**
   * @param request The request.
   * @see [CChatRoom_GetRolesForUser_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetRolesForUser_Response]
   */
  override fun getRolesForUser(request: CChatRoom_GetRolesForUser_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetRolesForUser")

  /**
   * @param request The request.
   * @see [CChatRoom_DeleteRoleFromUser_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteRoleFromUser_Response]
   */
  override fun deleteRoleFromUser(request: CChatRoom_DeleteRoleFromUser_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "DeleteRoleFromUser")

  /**
   * @param request The request.
   * @see [CChatRoom_JoinChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_JoinChatRoomGroup_Response]
   */
  override fun joinChatRoomGroup(request: CChatRoom_JoinChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "JoinChatRoomGroup")

  /**
   * @param request The request.
   * @see [CChatRoom_InviteFriendToChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_InviteFriendToChatRoomGroup_Response]
   */
  override fun inviteFriendToChatRoomGroup(request: CChatRoom_InviteFriendToChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "InviteFriendToChatRoomGroup")

  /**
   * @param request The request.
   * @see [CChatRoom_LeaveChatRoomGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_LeaveChatRoomGroup_Response]
   */
  override fun leaveChatRoomGroup(request: CChatRoom_LeaveChatRoomGroup_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "LeaveChatRoomGroup")

  /**
   * @param request The request.
   * @see [CChatRoom_CreateChatRoom_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateChatRoom_Response]
   */
  override fun createChatRoom(request: CChatRoom_CreateChatRoom_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "CreateChatRoom")

  /**
   * @param request The request.
   * @see [CChatRoom_DeleteChatRoom_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteChatRoom_Response]
   */
  override fun deleteChatRoom(request: CChatRoom_DeleteChatRoom_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "DeleteChatRoom")

  /**
   * @param request The request.
   * @see [CChatRoom_RenameChatRoom_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_RenameChatRoom_Response]
   */
  override fun renameChatRoom(request: CChatRoom_RenameChatRoom_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "RenameChatRoom")

  /**
   * @param request The request.
   * @see [CChatRoom_ReorderChatRoom_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_ReorderChatRoom_Response]
   */
  override fun reorderChatRoom(request: CChatRoom_ReorderChatRoom_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "ReorderChatRoom")

  /**
   * @param request The request.
   * @see [CChatRoom_SendChatMessage_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SendChatMessage_Response]
   */
  override fun sendChatMessage(request: CChatRoom_SendChatMessage_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "SendChatMessage")

  /**
   * @param request The request.
   * @see [CChatRoom_JoinVoiceChat_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_JoinVoiceChat_Response]
   */
  override fun joinVoiceChat(request: CChatRoom_JoinVoiceChat_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "JoinVoiceChat")

  /**
   * @param request The request.
   * @see [CChatRoom_LeaveVoiceChat_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_LeaveVoiceChat_Response]
   */
  override fun leaveVoiceChat(request: CChatRoom_LeaveVoiceChat_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "LeaveVoiceChat")

  /**
   * @param request The request.
   * @see [CChatRoom_GetMessageHistory_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetMessageHistory_Response]
   */
  override fun getMessageHistory(request: CChatRoom_GetMessageHistory_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetMessageHistory")

  /**
   * @param request The request.
   * @see [CChatRoom_GetMyChatRoomGroups_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetMyChatRoomGroups_Response]
   */
  override fun getMyChatRoomGroups(request: CChatRoom_GetMyChatRoomGroups_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetMyChatRoomGroups")

  /**
   * @param request The request.
   * @see [CChatRoom_GetChatRoomGroupState_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetChatRoomGroupState_Response]
   */
  override fun getChatRoomGroupState(request: CChatRoom_GetChatRoomGroupState_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetChatRoomGroupState")

  /**
   * @param request The request.
   * @see [CChatRoom_GetChatRoomGroupSummary_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetChatRoomGroupSummary_Response]
   */
  override fun getChatRoomGroupSummary(request: CChatRoom_GetChatRoomGroupSummary_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetChatRoomGroupSummary")

  /**
   * @param request The request.
   * @see [CChatRoom_SetAppChatRoomGroupForceActive_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetAppChatRoomGroupForceActive_Response]
   */
  override
      fun setAppChatRoomGroupForceActive(request: CChatRoom_SetAppChatRoomGroupForceActive_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "SetAppChatRoomGroupForceActive")

  /**
   * No return value.
   */
  override
      fun setAppChatRoomGroupStopForceActive(request: CChatRoom_SetAppChatRoomGroupStopForceActive_Notification) {
    sendNotification(request, "SetAppChatRoomGroupStopForceActive")
  }

  /**
   * No return value.
   */
  override fun ackChatMessage(request: CChatRoom_AckChatMessage_Notification) {
    sendNotification(request, "AckChatMessage")
  }

  /**
   * @param request The request.
   * @see [CChatRoom_CreateInviteLink_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_CreateInviteLink_Response]
   */
  override fun createInviteLink(request: CChatRoom_CreateInviteLink_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "CreateInviteLink")

  /**
   * @param request The request.
   * @see [CChatRoom_GetInviteLinkInfo_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteLinkInfo_Response]
   */
  override fun getInviteLinkInfo(request: CChatRoom_GetInviteLinkInfo_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetInviteLinkInfo")

  /**
   * @param request The request.
   * @see [CChatRoom_GetInviteInfo_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteInfo_Response]
   */
  override fun getInviteInfo(request: CChatRoom_GetInviteInfo_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetInviteInfo")

  /**
   * @param request The request.
   * @see [CChatRoom_GetInviteLinksForGroup_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteLinksForGroup_Response]
   */
  override fun getInviteLinksForGroup(request: CChatRoom_GetInviteLinksForGroup_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetInviteLinksForGroup")

  /**
   * @param request The request.
   * @see [CChatRoom_GetBanList_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetBanList_Response]
   */
  override fun getBanList(request: CChatRoom_GetBanList_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetBanList")

  /**
   * @param request The request.
   * @see [CChatRoom_GetInviteList_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetInviteList_Response]
   */
  override fun getInviteList(request: CChatRoom_GetInviteList_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetInviteList")

  /**
   * @param request The request.
   * @see [CChatRoom_DeleteInviteLink_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteInviteLink_Response]
   */
  override fun deleteInviteLink(request: CChatRoom_DeleteInviteLink_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "DeleteInviteLink")

  /**
   * @param request The request.
   * @see [CChatRoom_SetSessionActiveChatRoomGroups_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetSessionActiveChatRoomGroups_Response]
   */
  override
      fun setSessionActiveChatRoomGroups(request: CChatRoom_SetSessionActiveChatRoomGroups_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "SetSessionActiveChatRoomGroups")

  /**
   * @param request The request.
   * @see [CChatRoom_SetUserChatGroupPreferences_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SetUserChatGroupPreferences_Response]
   */
  override fun setUserChatGroupPreferences(request: CChatRoom_SetUserChatGroupPreferences_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "SetUserChatGroupPreferences")

  /**
   * @param request The request.
   * @see [CChatRoom_DeleteChatMessages_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_DeleteChatMessages_Response]
   */
  override fun deleteChatMessages(request: CChatRoom_DeleteChatMessages_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "DeleteChatMessages")

  /**
   * No return value.
   */
  override fun updateMemberListView(request: CChatRoom_UpdateMemberListView_Notification) {
    sendNotification(request, "UpdateMemberListView")
  }

  /**
   * @param request The request.
   * @see [CChatRoom_SearchMembers_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_SearchMembers_Response]
   */
  override fun searchMembers(request: CChatRoom_SearchMembers_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "SearchMembers")

  /**
   * @param request The request.
   * @see [CChatRoom_UpdateMessageReaction_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_UpdateMessageReaction_Response]
   */
  override fun updateMessageReaction(request: CChatRoom_UpdateMessageReaction_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "UpdateMessageReaction")

  /**
   * @param request The request.
   * @see [CChatRoom_GetMessageReactionReactors_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_GetMessageReactionReactors_Response]
   */
  override fun getMessageReactionReactors(request: CChatRoom_GetMessageReactionReactors_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetMessageReactionReactors")
}
