package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoomClient_MemberListViewUpdated_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_AckChatMessage_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_ChatMessageModified_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_ChatRoomGroupRoomsChange_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_ChatRoomHeaderState_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_IncomingChatMessage_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_MemberStateChange_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_MessageReaction_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CChatRoom_NotifyShouldRejoinChatRoomVoiceChat_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.ChatRoomClient_NotifyChatGroupUserStateChanged_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.ChatRoomClient_NotifyChatRoomDisconnect_Notification
import `in`.dragonbra.javasteam.rpc.interfaces.IChatRoomClient
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class ChatRoomClient(
  steamUnifiedMessages: SteamUnifiedMessages,
) : UnifiedService(steamUnifiedMessages),
    IChatRoomClient {
  /**
   * No return value.
   */
  override fun notifyIncomingChatMessage(request: CChatRoom_IncomingChatMessage_Notification) {
    sendNotification(request, "NotifyIncomingChatMessage")
  }

  /**
   * No return value.
   */
  override fun notifyChatMessageModified(request: CChatRoom_ChatMessageModified_Notification) {
    sendNotification(request, "NotifyChatMessageModified")
  }

  /**
   * No return value.
   */
  override fun notifyMemberStateChange(request: CChatRoom_MemberStateChange_Notification) {
    sendNotification(request, "NotifyMemberStateChange")
  }

  /**
   * No return value.
   */
  override
      fun notifyChatRoomHeaderStateChange(request: CChatRoom_ChatRoomHeaderState_Notification) {
    sendNotification(request, "NotifyChatRoomHeaderStateChange")
  }

  /**
   * No return value.
   */
  override
      fun notifyChatRoomGroupRoomsChange(request: CChatRoom_ChatRoomGroupRoomsChange_Notification) {
    sendNotification(request, "NotifyChatRoomGroupRoomsChange")
  }

  /**
   * No return value.
   */
  override
      fun notifyShouldRejoinChatRoomVoiceChat(request: CChatRoom_NotifyShouldRejoinChatRoomVoiceChat_Notification) {
    sendNotification(request, "NotifyShouldRejoinChatRoomVoiceChat")
  }

  /**
   * No return value.
   */
  override
      fun notifyChatGroupUserStateChanged(request: ChatRoomClient_NotifyChatGroupUserStateChanged_Notification) {
    sendNotification(request, "NotifyChatGroupUserStateChanged")
  }

  /**
   * No return value.
   */
  override fun notifyAckChatMessageEcho(request: CChatRoom_AckChatMessage_Notification) {
    sendNotification(request, "NotifyAckChatMessageEcho")
  }

  /**
   * No return value.
   */
  override
      fun notifyChatRoomDisconnect(request: ChatRoomClient_NotifyChatRoomDisconnect_Notification) {
    sendNotification(request, "NotifyChatRoomDisconnect")
  }

  /**
   * No return value.
   */
  override
      fun notifyMemberListViewUpdated(request: CChatRoomClient_MemberListViewUpdated_Notification) {
    sendNotification(request, "NotifyMemberListViewUpdated")
  }

  /**
   * No return value.
   */
  override fun notifyMessageReaction(request: CChatRoom_MessageReaction_Notification) {
    sendNotification(request, "NotifyMessageReaction")
  }
}
