package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CClanChatRooms_GetClanChatRoomInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CClanChatRooms_SetClanChatRoomPrivate_Request
import `in`.dragonbra.javasteam.rpc.interfaces.IClanChatRooms
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class ClanChatRooms(
  steamUnifiedMessages: SteamUnifiedMessages,
) : UnifiedService(steamUnifiedMessages),
    IClanChatRooms {
  /**
   * @param request The request.
   * @see [CClanChatRooms_GetClanChatRoomInfo_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CClanChatRooms_GetClanChatRoomInfo_Response]
   */
  override fun getClanChatRoomInfo(request: CClanChatRooms_GetClanChatRoomInfo_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetClanChatRoomInfo")

  /**
   * @param request The request.
   * @see [CClanChatRooms_SetClanChatRoomPrivate_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesChatSteamclient.CClanChatRooms_SetClanChatRoomPrivate_Response]
   */
  override fun setClanChatRoomPrivate(request: CClanChatRooms_SetClanChatRoomPrivate_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "SetClanChatRoomPrivate")
}
