package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CCloudGaming_CreateNonce_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CCloudGaming_GetTimeRemaining_Request
import `in`.dragonbra.javasteam.rpc.interfaces.ICloudGaming
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class CloudGaming(
  steamUnifiedMessages: SteamUnifiedMessages,
) : UnifiedService(steamUnifiedMessages),
    ICloudGaming {
  /**
   * @param request The request.
   * @see [CCloudGaming_CreateNonce_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CCloudGaming_CreateNonce_Response]
   */
  override fun createNonce(request: CCloudGaming_CreateNonce_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "CreateNonce")

  /**
   * @param request The request.
   * @see [CCloudGaming_GetTimeRemaining_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesAuthSteamclient.CCloudGaming_GetTimeRemaining_Response]
   */
  override fun getTimeRemaining(request: CCloudGaming_GetTimeRemaining_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetTimeRemaining")
}
