package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetCDNAuthToken_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetClientUpdateHosts_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetDepotPatchInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetManifestRequestCode_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetPeerContentInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetServersForSteamPipe_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_RequestPeerContentServer_Request
import `in`.dragonbra.javasteam.rpc.interfaces.IContentServerDirectory
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class ContentServerDirectory(
  steamUnifiedMessages: SteamUnifiedMessages,
) : UnifiedService(steamUnifiedMessages),
    IContentServerDirectory {
  /**
   * @param request The request.
   * @see [CContentServerDirectory_GetServersForSteamPipe_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetServersForSteamPipe_Response]
   */
  override
      fun getServersForSteamPipe(request: CContentServerDirectory_GetServersForSteamPipe_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetServersForSteamPipe")

  /**
   * @param request The request.
   * @see [CContentServerDirectory_GetDepotPatchInfo_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetDepotPatchInfo_Response]
   */
  override fun getDepotPatchInfo(request: CContentServerDirectory_GetDepotPatchInfo_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetDepotPatchInfo")

  /**
   * @param request The request.
   * @see [CContentServerDirectory_GetClientUpdateHosts_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetClientUpdateHosts_Response]
   */
  override fun getClientUpdateHosts(request: CContentServerDirectory_GetClientUpdateHosts_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetClientUpdateHosts")

  /**
   * @param request The request.
   * @see [CContentServerDirectory_GetManifestRequestCode_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetManifestRequestCode_Response]
   */
  override
      fun getManifestRequestCode(request: CContentServerDirectory_GetManifestRequestCode_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetManifestRequestCode")

  /**
   * @param request The request.
   * @see [CContentServerDirectory_GetCDNAuthToken_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetCDNAuthToken_Response]
   */
  override fun getCDNAuthToken(request: CContentServerDirectory_GetCDNAuthToken_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetCDNAuthToken")

  /**
   * @param request The request.
   * @see [CContentServerDirectory_RequestPeerContentServer_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_RequestPeerContentServer_Response]
   */
  override
      fun requestPeerContentServer(request: CContentServerDirectory_RequestPeerContentServer_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "RequestPeerContentServer")

  /**
   * @param request The request.
   * @see [CContentServerDirectory_GetPeerContentInfo_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesContentsystemSteamclient.CContentServerDirectory_GetPeerContentInfo_Response]
   */
  override fun getPeerContentInfo(request: CContentServerDirectory_GetPeerContentInfo_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetPeerContentInfo")
}
