package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CEmbeddedClient_AuthorizeCurrentDevice_Request
import `in`.dragonbra.javasteam.rpc.interfaces.IEmbeddedClient
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class EmbeddedClient(
  steamUnifiedMessages: SteamUnifiedMessages,
) : UnifiedService(steamUnifiedMessages),
    IEmbeddedClient {
  /**
   * @param request The request.
   * @see [CEmbeddedClient_AuthorizeCurrentDevice_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesUseraccountSteamclient.CEmbeddedClient_AuthorizeDevice_Response]
   */
  override fun authorizeCurrentDevice(request: CEmbeddedClient_AuthorizeCurrentDevice_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "AuthorizeCurrentDevice")
}
