package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_AckMessage_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_GetRecentMessages_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_IsInFriendsUIBeta_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_SendMessage_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_UpdateMessageReaction_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendsMessages_GetActiveMessageSessions_Request
import `in`.dragonbra.javasteam.rpc.interfaces.IFriendMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class FriendMessages(
  steamUnifiedMessages: SteamUnifiedMessages,
) : UnifiedService(steamUnifiedMessages),
    IFriendMessages {
  /**
   * @param request The request.
   * @see [CFriendMessages_GetRecentMessages_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_GetRecentMessages_Response]
   */
  override fun getRecentMessages(request: CFriendMessages_GetRecentMessages_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetRecentMessages")

  /**
   * @param request The request.
   * @see [CFriendsMessages_GetActiveMessageSessions_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendsMessages_GetActiveMessageSessions_Response]
   */
  override fun getActiveMessageSessions(request: CFriendsMessages_GetActiveMessageSessions_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetActiveMessageSessions")

  /**
   * @param request The request.
   * @see [CFriendMessages_SendMessage_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_SendMessage_Response]
   */
  override fun sendMessage(request: CFriendMessages_SendMessage_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "SendMessage")

  /**
   * No return value.
   */
  override fun ackMessage(request: CFriendMessages_AckMessage_Notification) {
    sendNotification(request, "AckMessage")
  }

  /**
   * @param request The request.
   * @see [CFriendMessages_IsInFriendsUIBeta_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_IsInFriendsUIBeta_Response]
   */
  override fun isInFriendsUIBeta(request: CFriendMessages_IsInFriendsUIBeta_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "IsInFriendsUIBeta")

  /**
   * @param request The request.
   * @see [CFriendMessages_UpdateMessageReaction_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_UpdateMessageReaction_Response]
   */
  override fun updateMessageReaction(request: CFriendMessages_UpdateMessageReaction_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "UpdateMessageReaction")
}
