package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_AckMessage_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_IncomingMessage_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesFriendmessagesSteamclient.CFriendMessages_MessageReaction_Notification
import `in`.dragonbra.javasteam.rpc.interfaces.IFriendMessagesClient
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class FriendMessagesClient(
  steamUnifiedMessages: SteamUnifiedMessages,
) : UnifiedService(steamUnifiedMessages),
    IFriendMessagesClient {
  /**
   * No return value.
   */
  override fun incomingMessage(request: CFriendMessages_IncomingMessage_Notification) {
    sendNotification(request, "IncomingMessage")
  }

  /**
   * No return value.
   */
  override fun notifyAckMessageEcho(request: CFriendMessages_AckMessage_Notification) {
    sendNotification(request, "NotifyAckMessageEcho")
  }

  /**
   * No return value.
   */
  override fun messageReaction(request: CFriendMessages_MessageReaction_Notification) {
    sendNotification(request, "MessageReaction")
  }
}
