package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_AddItem_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_CombineItemStacks_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_ConsumeItem_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_ConsumePlaytime_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_DevSetNextDrop_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_ExchangeItem_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_GetEligiblePromoItemDefIDs_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_GetInventory_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_GetItemDefMeta_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_GetUserPurchaseInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_InspectItem_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_ModifyItems_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_PurchaseFinalize_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_PurchaseInit_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_SplitItemStack_Request
import `in`.dragonbra.javasteam.rpc.interfaces.IInventory
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class Inventory(
  steamUnifiedMessages: SteamUnifiedMessages,
) : UnifiedService(steamUnifiedMessages),
    IInventory {
  /**
   * @param request The request.
   * @see [CInventory_GetInventory_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  override fun getInventory(request: CInventory_GetInventory_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetInventory")

  /**
   * @param request The request.
   * @see [CInventory_ExchangeItem_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  override fun exchangeItem(request: CInventory_ExchangeItem_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "ExchangeItem")

  /**
   * @param request The request.
   * @see [CInventory_GetEligiblePromoItemDefIDs_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_GetEligiblePromoItemDefIDs_Response]
   */
  override fun getEligiblePromoItemDefIDs(request: CInventory_GetEligiblePromoItemDefIDs_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetEligiblePromoItemDefIDs")

  /**
   * @param request The request.
   * @see [CInventory_AddItem_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  override fun addPromoItem(request: CInventory_AddItem_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "AddPromoItem")

  /**
   * @param request The request.
   * @see [CInventory_ModifyItems_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  override fun safeModifyItems(request: CInventory_ModifyItems_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "SafeModifyItems")

  /**
   * @param request The request.
   * @see [CInventory_ConsumePlaytime_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  override fun consumePlaytime(request: CInventory_ConsumePlaytime_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "ConsumePlaytime")

  /**
   * @param request The request.
   * @see [CInventory_ConsumeItem_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  override fun consumeItem(request: CInventory_ConsumeItem_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "ConsumeItem")

  /**
   * @param request The request.
   * @see [CInventory_AddItem_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  override fun devGenerateItem(request: CInventory_AddItem_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "DevGenerateItem")

  /**
   * @param request The request.
   * @see [CInventory_DevSetNextDrop_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  override fun devSetNextDrop(request: CInventory_DevSetNextDrop_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "DevSetNextDrop")

  /**
   * @param request The request.
   * @see [CInventory_SplitItemStack_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  override fun splitItemStack(request: CInventory_SplitItemStack_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "SplitItemStack")

  /**
   * @param request The request.
   * @see [CInventory_CombineItemStacks_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  override fun combineItemStacks(request: CInventory_CombineItemStacks_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "CombineItemStacks")

  /**
   * @param request The request.
   * @see [CInventory_GetItemDefMeta_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_GetItemDefMeta_Response]
   */
  override fun getItemDefMeta(request: CInventory_GetItemDefMeta_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetItemDefMeta")

  /**
   * @param request The request.
   * @see [CInventory_GetUserPurchaseInfo_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_GetUserPurchaseInfo_Response]
   */
  override fun getUserPurchaseInfo(request: CInventory_GetUserPurchaseInfo_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetUserPurchaseInfo")

  /**
   * @param request The request.
   * @see [CInventory_PurchaseInit_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_PurchaseInit_Response]
   */
  override fun purchaseInit(request: CInventory_PurchaseInit_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "PurchaseInit")

  /**
   * @param request The request.
   * @see [CInventory_PurchaseFinalize_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  override fun purchaseFinalize(request: CInventory_PurchaseFinalize_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "PurchaseFinalize")

  /**
   * @param request The request.
   * @see [CInventory_InspectItem_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesInventorySteamclient.CInventory_Response]
   */
  override fun inspectItem(request: CInventory_InspectItem_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "InspectItem")
}
