package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ApproveFeatureAccess_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ApprovePlaytime_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_DisableParentalSettings_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_DisableWithRecoveryCode_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_EnableParentalSettings_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_GetParentalSettings_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_GetRequests_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_GetSignedParentalSettings_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_LockClient_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ReportPlaytimeAndNotify_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_RequestFeatureAccess_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_RequestPlaytime_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_RequestRecoveryCode_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_SetParentalSettings_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ValidatePassword_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ValidateToken_Request
import `in`.dragonbra.javasteam.rpc.interfaces.IParental
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class Parental(
  steamUnifiedMessages: SteamUnifiedMessages,
) : UnifiedService(steamUnifiedMessages),
    IParental {
  /**
   * @param request The request.
   * @see [CParental_EnableParentalSettings_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_EnableParentalSettings_Response]
   */
  override fun enableParentalSettings(request: CParental_EnableParentalSettings_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "EnableParentalSettings")

  /**
   * @param request The request.
   * @see [CParental_DisableParentalSettings_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_DisableParentalSettings_Response]
   */
  override fun disableParentalSettings(request: CParental_DisableParentalSettings_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "DisableParentalSettings")

  /**
   * @param request The request.
   * @see [CParental_GetParentalSettings_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_GetParentalSettings_Response]
   */
  override fun getParentalSettings(request: CParental_GetParentalSettings_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetParentalSettings")

  /**
   * @param request The request.
   * @see [CParental_GetSignedParentalSettings_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_GetSignedParentalSettings_Response]
   */
  override fun getSignedParentalSettings(request: CParental_GetSignedParentalSettings_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetSignedParentalSettings")

  /**
   * @param request The request.
   * @see [CParental_SetParentalSettings_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_SetParentalSettings_Response]
   */
  override fun setParentalSettings(request: CParental_SetParentalSettings_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "SetParentalSettings")

  /**
   * @param request The request.
   * @see [CParental_ValidateToken_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ValidateToken_Response]
   */
  override fun validateToken(request: CParental_ValidateToken_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "ValidateToken")

  /**
   * @param request The request.
   * @see [CParental_ValidatePassword_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ValidatePassword_Response]
   */
  override fun validatePassword(request: CParental_ValidatePassword_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "ValidatePassword")

  /**
   * @param request The request.
   * @see [CParental_LockClient_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_LockClient_Response]
   */
  override fun lockClient(request: CParental_LockClient_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "LockClient")

  /**
   * @param request The request.
   * @see [CParental_RequestRecoveryCode_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_RequestRecoveryCode_Response]
   */
  override fun requestRecoveryCode(request: CParental_RequestRecoveryCode_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "RequestRecoveryCode")

  /**
   * @param request The request.
   * @see [CParental_DisableWithRecoveryCode_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_DisableWithRecoveryCode_Response]
   */
  override fun disableWithRecoveryCode(request: CParental_DisableWithRecoveryCode_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "DisableWithRecoveryCode")

  /**
   * @param request The request.
   * @see [CParental_RequestFeatureAccess_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_RequestFeatureAccess_Response]
   */
  override fun requestFeatureAccess(request: CParental_RequestFeatureAccess_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "RequestFeatureAccess")

  /**
   * @param request The request.
   * @see [CParental_ApproveFeatureAccess_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ApproveFeatureAccess_Response]
   */
  override fun approveFeatureAccess(request: CParental_ApproveFeatureAccess_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "ApproveFeatureAccess")

  /**
   * @param request The request.
   * @see [CParental_RequestPlaytime_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_RequestPlaytime_Response]
   */
  override fun requestPlaytime(request: CParental_RequestPlaytime_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "RequestPlaytime")

  /**
   * @param request The request.
   * @see [CParental_ApprovePlaytime_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ApprovePlaytime_Response]
   */
  override fun approvePlaytime(request: CParental_ApprovePlaytime_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "ApprovePlaytime")

  /**
   * @param request The request.
   * @see [CParental_GetRequests_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_GetRequests_Response]
   */
  override fun getRequests(request: CParental_GetRequests_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetRequests")

  /**
   * @param request The request.
   * @see [CParental_ReportPlaytimeAndNotify_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesParentalSteamclient.CParental_ReportPlaytimeAndNotify_Response]
   */
  override fun reportPlaytimeAndNotify(request: CParental_ReportPlaytimeAndNotify_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "ReportPlaytimeAndNotify")
}
