package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesPlayerSteamclient.CPlayer_CommunityPreferencesChanged_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesPlayerSteamclient.CPlayer_FriendEquippedProfileItemsChanged_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesPlayerSteamclient.CPlayer_FriendNicknameChanged_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesPlayerSteamclient.CPlayer_LastPlayedTimes_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesPlayerSteamclient.CPlayer_NewSteamAnnouncementState_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesPlayerSteamclient.CPlayer_PerFriendPreferencesChanged_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesPlayerSteamclient.CPlayer_PrivacySettingsChanged_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesPlayerSteamclient.CPlayer_TextFilterWordsChanged_Notification
import `in`.dragonbra.javasteam.rpc.interfaces.IPlayerClient
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class PlayerClient(
  steamUnifiedMessages: SteamUnifiedMessages,
) : UnifiedService(steamUnifiedMessages),
    IPlayerClient {
  /**
   * No return value.
   */
  override fun notifyLastPlayedTimes(request: CPlayer_LastPlayedTimes_Notification) {
    sendNotification(request, "NotifyLastPlayedTimes")
  }

  /**
   * No return value.
   */
  override fun notifyFriendNicknameChanged(request: CPlayer_FriendNicknameChanged_Notification) {
    sendNotification(request, "NotifyFriendNicknameChanged")
  }

  /**
   * No return value.
   */
  override
      fun notifyFriendEquippedProfileItemsChanged(request: CPlayer_FriendEquippedProfileItemsChanged_Notification) {
    sendNotification(request, "NotifyFriendEquippedProfileItemsChanged")
  }

  /**
   * No return value.
   */
  override
      fun notifyNewSteamAnnouncementState(request: CPlayer_NewSteamAnnouncementState_Notification) {
    sendNotification(request, "NotifyNewSteamAnnouncementState")
  }

  /**
   * No return value.
   */
  override
      fun notifyCommunityPreferencesChanged(request: CPlayer_CommunityPreferencesChanged_Notification) {
    sendNotification(request, "NotifyCommunityPreferencesChanged")
  }

  /**
   * No return value.
   */
  override fun notifyTextFilterWordsChanged(request: CPlayer_TextFilterWordsChanged_Notification) {
    sendNotification(request, "NotifyTextFilterWordsChanged")
  }

  /**
   * No return value.
   */
  override
      fun notifyPerFriendPreferencesChanged(request: CPlayer_PerFriendPreferencesChanged_Notification) {
    sendNotification(request, "NotifyPerFriendPreferencesChanged")
  }

  /**
   * No return value.
   */
  override
      fun notifyPrivacyPrivacySettingsChanged(request: CPlayer_PrivacySettingsChanged_Notification) {
    sendNotification(request, "NotifyPrivacyPrivacySettingsChanged")
  }
}
