package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_AllocateRelayServer_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_AllocateSDR_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_CreateRemotePlayTogetherInvitation_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_DeleteRemotePlayTogetherInvitation_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_GetPairingInfo_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_Online_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_ReplyPacket_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_SteamBroadcast_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_SteamToSteam_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemotePlayTogether_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemotePlay_SessionStarted_Request
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemotePlay_SessionStopped_Notification
import `in`.dragonbra.javasteam.rpc.interfaces.IRemoteClient
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.callback.ServiceMethodResponse
import `in`.dragonbra.javasteam.types.AsyncJobSingle
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class RemoteClient(
  steamUnifiedMessages: SteamUnifiedMessages,
) : UnifiedService(steamUnifiedMessages),
    IRemoteClient {
  /**
   * @param request The request.
   * @see [CRemoteClient_GetPairingInfo_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_GetPairingInfo_Response]
   */
  override fun getPairingInfo(request: CRemoteClient_GetPairingInfo_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "GetPairingInfo")

  /**
   * No return value.
   */
  override fun notifyOnline(request: CRemoteClient_Online_Notification) {
    sendNotification(request, "NotifyOnline")
  }

  /**
   * No return value.
   */
  override fun notifyReplyPacket(request: CRemoteClient_ReplyPacket_Notification) {
    sendNotification(request, "NotifyReplyPacket")
  }

  /**
   * @param request The request.
   * @see [CRemoteClient_AllocateRelayServer_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_AllocateRelayServer_Response]
   */
  override fun allocateRelayServer(request: CRemoteClient_AllocateRelayServer_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "AllocateRelayServer")

  /**
   * @param request The request.
   * @see [CRemoteClient_AllocateSDR_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_AllocateSDR_Response]
   */
  override fun allocateSDR(request: CRemoteClient_AllocateSDR_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "AllocateSDR")

  /**
   * No return value.
   */
  override fun sendSteamBroadcastPacket(request: CRemoteClient_SteamBroadcast_Notification) {
    sendNotification(request, "SendSteamBroadcastPacket")
  }

  /**
   * No return value.
   */
  override fun sendSteamToSteamPacket(request: CRemoteClient_SteamToSteam_Notification) {
    sendNotification(request, "SendSteamToSteamPacket")
  }

  /**
   * @param request The request.
   * @see [CRemotePlay_SessionStarted_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemotePlay_SessionStarted_Response]
   */
  override fun sendRemotePlaySessionStarted(request: CRemotePlay_SessionStarted_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request, "SendRemotePlaySessionStarted")

  /**
   * No return value.
   */
  override fun sendRemotePlaySessionStopped(request: CRemotePlay_SessionStopped_Notification) {
    sendNotification(request, "SendRemotePlaySessionStopped")
  }

  /**
   * No return value.
   */
  override fun sendRemotePlayTogetherPacket(request: CRemotePlayTogether_Notification) {
    sendNotification(request, "SendRemotePlayTogetherPacket")
  }

  /**
   * @param request The request.
   * @see [CRemoteClient_CreateRemotePlayTogetherInvitation_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_CreateRemotePlayTogetherInvitation_Response]
   */
  override
      fun createRemotePlayTogetherInvitation(request: CRemoteClient_CreateRemotePlayTogetherInvitation_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request,
      "CreateRemotePlayTogetherInvitation")

  /**
   * @param request The request.
   * @see [CRemoteClient_DeleteRemotePlayTogetherInvitation_Request]
   * @returns
   * [in.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_DeleteRemotePlayTogetherInvitation_Response]
   */
  override
      fun deleteRemotePlayTogetherInvitation(request: CRemoteClient_DeleteRemotePlayTogetherInvitation_Request):
      AsyncJobSingle<ServiceMethodResponse> = sendMessage(request,
      "DeleteRemotePlayTogetherInvitation")
}
