package `in`.dragonbra.javasteam.rpc.service

import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_RegisterStatusUpdate_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_RemotePacket_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_SteamBroadcast_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_SteamToSteam_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemoteClient_UnregisterStatusUpdate_Notification
import `in`.dragonbra.javasteam.protobufs.steamclient.SteammessagesRemoteclientServiceMessages.CRemotePlayTogether_Notification
import `in`.dragonbra.javasteam.rpc.interfaces.IRemoteClientSteamClient
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.SteamUnifiedMessages
import `in`.dragonbra.javasteam.steam.handlers.steamunifiedmessages.UnifiedService
import kotlin.Suppress

/**
 * @author Lossy
 * @since 2024-04-10
 */
@Suppress(
  "KDocUnresolvedReference",
  "RedundantVisibilityModifier",
  "unused",
)
public class RemoteClientSteamClient(
  steamUnifiedMessages: SteamUnifiedMessages,
) : UnifiedService(steamUnifiedMessages),
    IRemoteClientSteamClient {
  /**
   * No return value.
   */
  override
      fun notifyRegisterStatusUpdate(request: CRemoteClient_RegisterStatusUpdate_Notification) {
    sendNotification(request, "NotifyRegisterStatusUpdate")
  }

  /**
   * No return value.
   */
  override
      fun notifyUnregisterStatusUpdate(request: CRemoteClient_UnregisterStatusUpdate_Notification) {
    sendNotification(request, "NotifyUnregisterStatusUpdate")
  }

  /**
   * No return value.
   */
  override fun notifyRemotePacket(request: CRemoteClient_RemotePacket_Notification) {
    sendNotification(request, "NotifyRemotePacket")
  }

  /**
   * No return value.
   */
  override fun notifySteamBroadcastPacket(request: CRemoteClient_SteamBroadcast_Notification) {
    sendNotification(request, "NotifySteamBroadcastPacket")
  }

  /**
   * No return value.
   */
  override fun notifySteamToSteamPacket(request: CRemoteClient_SteamToSteam_Notification) {
    sendNotification(request, "NotifySteamToSteamPacket")
  }

  /**
   * No return value.
   */
  override fun notifyRemotePlayTogetherPacket(request: CRemotePlayTogether_Notification) {
    sendNotification(request, "NotifyRemotePlayTogetherPacket")
  }
}
