/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.base;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.GeneratedMessage;
import in.dragonbra.javasteam.base.AClientMsgProtobuf;
import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.base.MsgBase;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.generated.MsgHdrProtoBuf;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.SeekOrigin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClientMsgProtobuf<BodyType extends GeneratedMessage.Builder<BodyType>>
extends AClientMsgProtobuf {
    private static final Logger logger = LogManager.getLogger(ClientMsgProtobuf.class);
    private BodyType body;
    private final Class<? extends AbstractMessage> clazz;

    public ClientMsgProtobuf(Class<? extends AbstractMessage> clazz, IPacketMsg msg) {
        this(clazz, msg, 64);
        if (!msg.isProto()) {
            logger.debug("ClientMsgProtobuf<" + clazz.getSimpleName() + "> used for non-proto message!");
        }
        this.deserialize(msg.getData());
    }

    public ClientMsgProtobuf(Class<? extends AbstractMessage> clazz, IPacketMsg msg, int payloadReserve) {
        this(clazz, msg.getMsgType(), payloadReserve);
    }

    public ClientMsgProtobuf(Class<? extends AbstractMessage> clazz, EMsg eMsg) {
        this(clazz, eMsg, 64);
    }

    public ClientMsgProtobuf(Class<? extends AbstractMessage> clazz, EMsg eMsg, int payloadReserve) {
        super(payloadReserve);
        this.clazz = clazz;
        try {
            Method m = clazz.getMethod("newBuilder", new Class[0]);
            this.body = (GeneratedMessage.Builder)m.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.debug(e);
        }
        ((MsgHdrProtoBuf)this.getHeader()).setEMsg(eMsg);
    }

    public ClientMsgProtobuf(Class<? extends AbstractMessage> clazz, EMsg eMsg, MsgBase<MsgHdrProtoBuf> msg) {
        this(clazz, eMsg, msg, 64);
    }

    public ClientMsgProtobuf(Class<? extends AbstractMessage> clazz, EMsg eMsg, MsgBase<MsgHdrProtoBuf> msg, int payloadReserve) {
        this(clazz, eMsg, payloadReserve);
        ((MsgHdrProtoBuf)this.getHeader()).getProto().setJobidTarget(msg.getHeader().getProto().getJobidSource());
    }

    public BodyType getBody() {
        return this.body;
    }

    public void setBody(BodyType _body) {
        this.body = _body;
    }

    @Override
    public byte[] serialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(0);
        try {
            ((MsgHdrProtoBuf)this.getHeader()).serialize(baos);
            baos.write(this.body.build().toByteArray());
            baos.write(this.payload.toByteArray());
        }
        catch (IOException e) {
            logger.debug(e);
        }
        return baos.toByteArray();
    }

    @Override
    public void deserialize(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        BinaryReader ms = new BinaryReader(new ByteArrayInputStream(data));
        try {
            ((MsgHdrProtoBuf)this.getHeader()).deserialize(ms);
            Method m = this.clazz.getMethod("newBuilder", new Class[0]);
            this.body = (GeneratedMessage.Builder)m.invoke(null, new Object[0]);
            this.body.mergeFrom((InputStream)ms);
            this.payload.write(data, ms.getPosition(), ms.available());
            this.payload.seek(0L, SeekOrigin.BEGIN);
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.debug(e);
        }
    }
}

