/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.base;

import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.base.ISteamSerializableMessage;
import in.dragonbra.javasteam.base.MsgBase;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.generated.MsgHdr;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import in.dragonbra.javasteam.util.stream.SeekOrigin;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class Msg<BodyType extends ISteamSerializableMessage>
extends MsgBase<MsgHdr> {
    private static final Logger logger = LogManager.getLogger(Msg.class);
    private BodyType body;

    public Msg(Class<? extends BodyType> bodyType) {
        this(bodyType, 0);
    }

    public Msg(Class<? extends BodyType> bodyType, int payloadReserve) {
        super(MsgHdr.class, payloadReserve);
        try {
            this.body = (ISteamSerializableMessage)bodyType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.debug(e);
        }
        ((MsgHdr)this.getHeader()).setEMsg(this.body.getEMsg());
    }

    public Msg(Class<? extends BodyType> bodyType, MsgBase<MsgHdr> msg) {
        this(bodyType, msg, 0);
    }

    public Msg(Class<? extends BodyType> bodyType, MsgBase<MsgHdr> msg, int payloadReserve) {
        this((Class<BodyType>)bodyType, payloadReserve);
        if (msg == null) {
            throw new IllegalArgumentException("msg is null");
        }
        ((MsgHdr)this.getHeader()).setTargetJobID(msg.getHeader().getSourceJobID());
    }

    public Msg(Class<? extends BodyType> bodyType, IPacketMsg msg) {
        this((Class<BodyType>)bodyType);
        if (msg == null) {
            throw new IllegalArgumentException("msg is null");
        }
        this.deserialize(msg.getData());
    }

    @Override
    public boolean isProto() {
        return false;
    }

    @Override
    public EMsg getMsgType() {
        return ((MsgHdr)this.getHeader()).getMsg();
    }

    @Override
    public int getSessionID() {
        return 0;
    }

    @Override
    public void setSessionID(int sessionID) {
    }

    @Override
    public SteamID getSteamID() {
        return null;
    }

    @Override
    public void setSteamID(SteamID steamID) {
    }

    @Override
    public JobID getTargetJobID() {
        return new JobID(((MsgHdr)this.getHeader()).getTargetJobID());
    }

    @Override
    public void setTargetJobID(JobID jobID) {
        if (jobID == null) {
            throw new IllegalArgumentException("jobID is null");
        }
        ((MsgHdr)this.getHeader()).setTargetJobID(jobID.getValue());
    }

    @Override
    public JobID getSourceJobID() {
        return new JobID(((MsgHdr)this.getHeader()).getSourceJobID());
    }

    @Override
    public void setSourceJobID(JobID jobID) {
        if (jobID == null) {
            throw new IllegalArgumentException("jobID is null");
        }
        ((MsgHdr)this.getHeader()).setSourceJobID(jobID.getValue());
    }

    @Override
    public byte[] serialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(0);
        try {
            ((MsgHdr)this.getHeader()).serialize(baos);
            this.body.serialize(baos);
            baos.write(this.payload.toByteArray());
        }
        catch (IOException e) {
            logger.debug(e);
        }
        return baos.toByteArray();
    }

    @Override
    public void deserialize(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        MemoryStream ms = new MemoryStream(data);
        try {
            ((MsgHdr)this.getHeader()).deserialize(ms);
            this.body.deserialize(ms);
        }
        catch (IOException e) {
            logger.debug(e);
        }
        this.payload.write(data, (int)ms.getPosition(), ms.available());
        this.payload.seek(0L, SeekOrigin.BEGIN);
    }

    public BodyType getBody() {
        return this.body;
    }
}

