/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.base;

import in.dragonbra.javasteam.base.IPacketMsg;
import in.dragonbra.javasteam.enums.EMsg;
import in.dragonbra.javasteam.generated.MsgHdrProtoBuf;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class PacketClientMsgProtobuf
implements IPacketMsg {
    private final EMsg msgType;
    private final byte[] payload;
    private final MsgHdrProtoBuf header;

    public PacketClientMsgProtobuf(EMsg eMsg, byte[] data) throws IOException {
        this.msgType = eMsg;
        this.payload = data;
        this.header = new MsgHdrProtoBuf();
        try (ByteArrayInputStream stream = new ByteArrayInputStream(data);){
            this.header.deserialize(stream);
        }
    }

    public MsgHdrProtoBuf getHeader() {
        return this.header;
    }

    @Override
    public boolean isProto() {
        return true;
    }

    @Override
    public EMsg getMsgType() {
        return this.msgType;
    }

    @Override
    public long getTargetJobID() {
        return this.header.getProto().getJobidTarget();
    }

    @Override
    public long getSourceJobID() {
        return this.header.getProto().getJobidSource();
    }

    @Override
    public byte[] getData() {
        return this.payload;
    }
}

