/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.enums;

import java.util.EnumSet;

public enum EClanPermission {
    Nobody(0),
    Owner(1),
    Officer(2),
    OwnerAndOfficer(3),
    Member(4),
    Moderator(8),
    OGGGameOwner(16),
    NonMember(128);

    public static final EnumSet<EClanPermission> OwnerOfficerModerator;
    public static final EnumSet<EClanPermission> AllMembers;
    public static final EnumSet<EClanPermission> MemberAllowed;
    public static final EnumSet<EClanPermission> ModeratorAllowed;
    public static final EnumSet<EClanPermission> OfficerAllowed;
    public static final EnumSet<EClanPermission> OwnerAllowed;
    public static final EnumSet<EClanPermission> Anybody;
    private final int code;

    private EClanPermission(int code) {
        this.code = code;
    }

    public int code() {
        return this.code;
    }

    public static EnumSet<EClanPermission> from(int code) {
        EnumSet<EClanPermission> set = EnumSet.noneOf(EClanPermission.class);
        for (EClanPermission e : EClanPermission.values()) {
            if ((e.code & code) != e.code) continue;
            set.add(e);
        }
        return set;
    }

    public static int code(EnumSet<EClanPermission> flags) {
        int code = 0;
        for (EClanPermission flag : flags) {
            code |= flag.code;
        }
        return code;
    }

    static {
        OwnerOfficerModerator = EnumSet.of(Owner, Officer, Moderator);
        AllMembers = EnumSet.of(Owner, Officer, Moderator, Member);
        MemberAllowed = EnumSet.of(NonMember, Member);
        ModeratorAllowed = EnumSet.of(NonMember, Member, Moderator);
        OfficerAllowed = EnumSet.of(NonMember, Member, Moderator, Officer);
        OwnerAllowed = EnumSet.of(NonMember, Member, Moderator, Officer, Owner);
        Anybody = EnumSet.of(NonMember, Member, Moderator, Officer, Owner);
    }
}

