/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.networking.steam3;

import in.dragonbra.javasteam.networking.steam3.INetFilterEncryption;
import in.dragonbra.javasteam.util.crypto.CryptoException;
import in.dragonbra.javasteam.util.crypto.CryptoHelper;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;

public class NetFilterEncryptionWithHMAC
implements INetFilterEncryption {
    private static final Logger logger = LogManager.getLogger(NetFilterEncryptionWithHMAC.class);
    private final byte[] sessionKey;
    private final byte[] hmacSecret;

    public NetFilterEncryptionWithHMAC(byte[] sessionKey) {
        if (sessionKey.length != 32) {
            logger.debug("AES session key was not 32 bytes!");
        }
        this.sessionKey = sessionKey;
        this.hmacSecret = new byte[16];
        System.arraycopy(sessionKey, 0, this.hmacSecret, 0, this.hmacSecret.length);
    }

    @Override
    public byte[] processIncoming(byte[] data) {
        try {
            return CryptoHelper.symmetricDecryptHMACIV(data, this.sessionKey, this.hmacSecret);
        }
        catch (CryptoException e) {
            throw new IllegalStateException("Unable to decrypt incoming packet", e);
        }
    }

    @Override
    public byte[] processOutgoing(byte[] data) {
        try {
            return CryptoHelper.symmetricEncryptWithHMACIV(data, this.sessionKey, this.hmacSecret);
        }
        catch (CryptoException e) {
            throw new IllegalStateException("Unable to encrypt outgoing packet", e);
        }
    }
}

