/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.networking.steam3;

import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.net.URI;
import java.nio.ByteBuffer;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;

class WebSocketCMClient
extends WebSocketClient {
    private static final Logger logger = LogManager.getLogger(WebSocketCMClient.class);
    private final WSListener listener;

    WebSocketCMClient(URI serverUri, int timeout, WSListener listener) {
        super(serverUri, (Draft)new Draft_6455(), null, timeout);
        this.listener = listener;
    }

    public void onOpen(ServerHandshake handshakeData) {
        if (this.listener != null) {
            this.listener.onOpen();
        }
    }

    public void onMessage(String message) {
        logger.debug("got string message: " + message);
    }

    public void onMessage(ByteBuffer bytes) {
        if (this.listener != null) {
            byte[] data = new byte[bytes.remaining()];
            bytes.get(data);
            this.listener.onData(data);
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        if (this.listener != null) {
            this.listener.onClose(remote);
        }
    }

    public void onError(Exception ex) {
        if (this.listener != null) {
            this.listener.onError(ex);
        }
    }

    static interface WSListener {
        public void onData(byte[] var1);

        public void onClose(boolean var1);

        public void onError(Exception var1);

        public void onOpen();
    }
}

